from collections import deque
import sys


def solve() -> None:
    data = sys.stdin.buffer.read().split()
    if not data:
        return
    it = iter(data)
    n = int(next(it))
    queue = deque()
    for _ in range(n):
        name = next(it).decode()
        length = int(next(it))
        queue.append((name, length))

    m = int(next(it))
    events = []
    for _ in range(m):
        t = int(next(it))
        name = next(it).decode()
        length = int(next(it))
        events.append((t, name, length))

    res: list[tuple[str, int]] = []
    idx = 0
    current_time = 0
    current_song: tuple[str, int] | None = None
    current_end = 0

    while queue or current_song is not None or idx < m:
        if current_song is None:
            if not queue:
                if idx >= m:
                    break
                current_time = max(current_time, events[idx][0])
                time_ref = events[idx][0]
                current_time = time_ref
                while idx < m and events[idx][0] == time_ref:
                    _, name, length = events[idx]
                    queue.appendleft((name, length))
                    idx += 1
                if not queue:
                    continue
            current_song = queue.popleft()
            res.append((current_song[0], current_time))
            current_end = current_time + current_song[1]
            continue

        next_event_time = events[idx][0] if idx < m else None
        if next_event_time is not None and next_event_time < current_end:
            current_time = next_event_time
            while idx < m and events[idx][0] == current_time:
                _, name, length = events[idx]
                queue.appendleft((name, length))
                idx += 1
            continue

        current_time = current_end
        if next_event_time is not None and next_event_time == current_end:
            while idx < m and events[idx][0] == current_time:
                _, name, length = events[idx]
                queue.appendleft((name, length))
                idx += 1
        current_song = None

    out_lines = [f\"{name} {start}\" for name, start in res]
    sys.stdout.write(\"\\n\".join(out_lines))


if __name__ == \"__main__\":
    solve()
