import sys


def solve() -> None:
    data = sys.stdin.buffer.read().split()
    if not data:
        return
    it = iter(data)
    t = int(next(it))
    out_lines = []
    for _ in range(t):
        n = int(next(it))
        parity: dict[int, int] = {}
        for _ in range(n):
            x = int(next(it))
            parity[x] = parity.get(x, 0) ^ 1  # toggle parity
        candidate = -1
        for val, bit in parity.items():
            if bit and val > candidate:
                candidate = val
        out_lines.append(str(candidate))
    sys.stdout.write("\n".join(out_lines))


if __name__ == "__main__":
    solve()
