#include <bits/stdc++.h>
#define int long long

using namespace std;

const int M = 1e4 + 1;
const int N = 3e3 + 1;
const int inf = 1e18;

int dp[2 * M + 5][N];
bool w[2 * M + 5][N];

int X[N], C[N];

int32_t main() {
    ios_base::sync_with_stdio(0);
    cin.tie(nullptr);

    #ifdef LOCAL
        freopen("input.txt", "r", stdin);
        freopen("output.txt", "w", stdout);
    #endif // LOCAL

    int t;
    cin >> t;

    while (t--) {
        int n, l;
        cin >> n >> l;

        for (int i = 0; i < n; ++i) {
            cin >> X[i];
        }

        for (int i = 0; i < n; ++i) {
            cin >> C[i];
        }

        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j < 2 * M + 5; ++j) {
                dp[j][i] = inf;
                w[j][i] = 0;
            }
        }

        dp[M][0] = 0;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                for (int j = 0; j < 2 * M + 5; ++j) {
                    dp[j][i] = dp[j][i - 1];
                }
            }

            queue<pair<int, int>> q;
            auto add = [&](int v, int c) {
                if (v < 0 || v >= 2 * M + 5 || dp[v][i] < c || (dp[v][i] == c && w[v][i])) {
                    return;
                }

                dp[v][i] = c;
                w[v][i] = 1;

                q.push({v, c});
            };

            for (int j = 0; j < 2 * M + 5; ++j) {
                add(j + X[i], dp[j][i] + (w[j][i] ? 0 : C[i]));
                add(j - X[i], dp[j][i] + (w[j][i] ? 0 : C[i]));
            }

            while (!q.empty()) {
                auto [v, c] = q.front();
                q.pop();

                add(v + X[i], c);
                add(v - X[i], c);
            }
        }

        cout << (dp[l + M][n - 1] == inf ? -1 : dp[l + M][n - 1]) << "\n";
    }

    return 0;
}
