#include <bits/stdc++.h>
#define int long long

using namespace std;

const int N = 1e5 + 5;

int a[N];

struct {
    struct node {
        int vl, vr, sz, ans;
        int pref_up, pref_down;
        int suff_up, suff_down;
        int pmid_dw, smid_dw;

        void combine(node& l, node& r) {
            if (l.pref_up == l.sz && l.vr + 1 == r.vl) {
                pref_up = l.pref_up + r.pref_up;
                pmid_dw = r.pmid_dw;
            } else {
                pref_up = l.pref_up;
                pmid_dw = l.pmid_dw;

                if (pref_up + pmid_dw == l.sz && l.vr == r.vl + 1) {
                    pmid_dw += r.pref_down;
                }
            }

            if (l.pref_down == l.sz && l.vr == r.vl + 1) {
                pref_down = l.pref_down + r.pref_down;
            } else {
                pref_down = l.pref_down;
            }

            if (r.suff_up == r.sz && l.vr == r.vl + 1) {
                suff_up = l.suff_up + r.suff_up;
                smid_dw = l.smid_dw;
            } else {
                suff_up = r.suff_up;
                smid_dw = r.smid_dw;

                if (suff_up + smid_dw == r.sz && l.vr + 1 == r.vl) {
                    smid_dw += l.suff_down;
                }
            }

            if (r.suff_down == r.sz && l.vr + 1 == r.vl) {
                suff_down = l.suff_down + r.suff_down;
            } else {
                suff_down = r.suff_down;
            }

            ans = max(l.ans, r.ans);
            if (abs(l.vr - r.vl) == 1) {
                if (l.vr < r.vl) {
                    int left = l.suff_down;
                    int right = r.pref_down;
                    ans = max(ans, min(left, right - 1) * 2 + 1);
                } else {
                    int left = l.suff_down;
                    int right = r.pref_down;
                    ans = max(ans, min(left - 1, right) * 2 + 1);
                }
            }

            vl = l.vl, vr = r.vr;
            sz = l.sz + r.sz;
        }
    };

    node t[4 * N];

    void build(int v, int tl, int tr) {
        if (tl == tr) {
            t[v].sz = t[v].ans = 1;
            t[v].vl = t[v].vr = a[tl];
            t[v].pref_down = t[v].pref_up = 1;
            t[v].suff_down = t[v].suff_up = 1;
            t[v].pmid_dw = t[v].smid_dw = 0;
            return;
        }

        int tm = (tl + tr) >> 1;

        build(v << 1, tl, tm);
        build(v << 1 | 1, tm + 1, tr);

        t[v].combine(t[v << 1], t[v << 1 | 1]);
    }
    void update(int v, int tl, int tr, int l, int x) {
        if (tl == tr) {
            t[v].sz = t[v].ans = 1;
            t[v].vl = t[v].vr = x;
            t[v].pref_down = t[v].pref_up = 1;
            t[v].suff_down = t[v].suff_up = 1;
            t[v].pmid_dw = t[v].smid_dw = 0;
            return;
        }

        int tm = (tl + tr) >> 1;

        if (l <= tm) {
            update(v << 1, tl, tm, l, x);
        } else {
            update(v << 1 | 1, tm + 1, tr, l, x);
        }

        t[v].combine(t[v << 1], t[v << 1 | 1]);
    }
    int get() {
        return t[1].ans;
    }
} T;

int32_t main() {
    ios_base::sync_with_stdio(0);
    cin.tie(nullptr);

    #ifdef LOCAL
        freopen("input.txt", "r", stdin);
        freopen("output.txt", "w", stdout);
    #endif // LOCAL

    int n;
    cin >> n;

    for (int i = 1; i <= n; ++i) {
        cin >> a[i];
    }

    T.build(1, 1, n);

    cout << T.get() << "\n";

    int q;
    cin >> q;

    while (q--) {
        int l, x;
        cin >> l >> x;

        T.update(1, 1, n, l, x);
        cout << T.get() << "\n";
    }

    return 0;
}
