def gcd(a, b):
    while b:
        a, b = b, a % b
    return a

INF = 10**18

t = int(input().strip())
for _ in range(t):
    n, L = map(int, input().split())
    xs = []
    while len(xs) < n:
        xs += list(map(int, input().split()))
    cs = []
    while len(cs) < n:
        cs += list(map(int, input().split()))

    Labs = L if L >= 0 else -L
    if Labs == 0:
        print(0)
        continue

    # divisors of Labs
    divs = []
    r = int(Labs**0.5)
    for d in range(1, r+1):
        if Labs % d == 0:
            divs.append(d)
            if d * d != Labs:
                divs.append(Labs // d)
    divs.sort()  # increasing
    m = len(divs)
    index = {d:i for i,d in enumerate(divs)}

    dp = [INF] * m  # dp[i] = min cost to get gcd == divs[i]

    # precompute g_i = gcd(x_i, Labs) expressed as index
    ginds = []
    for x in xs:
        g = gcd(x, Labs)
        ginds.append(index[g])

    for i in range(n):
        gi = ginds[i]
        cost = cs[i]

        ndp = dp[:]  # copy
        # take this item alone
        if cost < ndp[gi]:
            ndp[gi] = cost

        # combine with existing gcd states
        for j in range(m):
            if dp[j] == INF:
                continue
            curg = divs[j]
            newg = gcd(curg, divs[gi])
            nj = index[newg]
            nc = dp[j] + cost
            if nc < ndp[nj]:
                ndp[nj] = nc

        dp = ndp

    ans = min(dp)  # all divs divide Labs, so any dp entry is candidate
    print(ans if ans < INF else -1)
