def isqrt_manual(x):
    if x < 2:
        return x
    r = int(x ** 0.5)
    while (r+1)*(r+1) <= x:
        r += 1
    while r*r > x:
        r -= 1
    return r

# количество делителей числа
def divisors_count(x):
    cnt = 1
    d = 2
    limit = isqrt_manual(x)
    # пробуем делители до sqrt(x)
    while d <= limit:
        if x % d == 0:
            exp = 1
            x //= d
            while x % d == 0:
                exp += 1
                x //= d
            cnt *= (exp + 1)
            limit = isqrt_manual(x)
        d += 1 if d == 2 else 2  # сначала 2, потом только нечётные
    if x > 1:
        cnt *= 2
    return cnt

# правильный Grundy
def grundy(x):
    return (divisors_count(x) - 1) // 2

t = int(input())
for _ in range(t):
    n = int(input())
    arr = []
    while len(arr) < n:
        arr += list(map(int, input().split()))
    xr = 0
    for x in arr:
        xr ^= grundy(x)
    print("Yes" if xr != 0 else "No")