import sys
from math import gcd
MOD = 998244353
CAP = 1 << 62

def safe_lcm(a, b):
    if a == 0 or b == 0:
        return 0
    g = gcd(a, b)
    # compute (a//g)*b safely
    t = (a // g) * b
    if t > CAP:
        return CAP
    return t

def main():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    it = iter(data)
    n = int(next(it))
    a = [0] * (n + 1)
    for i in range(1, n+1):
        a[i] = int(next(it))

    pref = [0] * (n + 1)   # pref[0]=0, pref[i]=gcd(a1..ai)
    for i in range(1, n+1):
        pref[i] = gcd(pref[i-1], a[i])
    suff = [0] * (n + 2)   # suff[n+1]=0, suff[i]=gcd(ai..an)
    for i in range(n, 0, -1):
        suff[i] = gcd(suff[i+1], a[i])

    pref_groups = []  # list of (val, l, r) for indices 0..n
    i = 0
    while i <= n:
        j = i
        v = pref[i]
        while j+1 <= n and pref[j+1] == v:
            j += 1
        pref_groups.append((v, i, j))
        i = j+1
    pref_starts = [g[1] for g in pref_groups]

    ans = 0
    cur = []  # list of (lcmVal, minStart) for segments ending at previous j
    for j in range(1, n+1):
        tmp = [(a[j], j)]
        for (lv, st) in cur:
            nl = safe_lcm(lv, a[j])
            if nl == tmp[-1][0]:
                # extend start to earlier
                tmp[-1] = (tmp[-1][0], st)
            else:
                tmp.append((nl, st))
        cur = tmp

        prevStart = j+1
        for (lcmVal, start) in cur:
            L = start
            R = prevStart - 1
            prevStart = start
            if L > R:
                continue
            pL = L - 1
            pR = R - 1
            # binary search first pref_group with l >= pL
            import bisect
            idx = bisect.bisect_left(pref_starts, pL)
            if idx > 0 and pref_groups[idx][1] > pL:
                idx -= 1
            # advance until group intersects pL..pR
            while idx < len(pref_groups) and pref_groups[idx][2] < pL:
                idx += 1
            curIdx = idx
            while curIdx < len(pref_groups) and pref_groups[curIdx][1] <= pR:
                gl, gl_l, gl_r = pref_groups[curIdx]
                il = pL if pL > gl_l else gl_l
                ir = pR if pR < gl_r else gl_r
                if il <= ir:
                    cnt = ir - il + 1
                    g2 = gcd(gl, suff[j+1])
                    tval = gcd(g2, lcmVal)
                    ans += (cnt * (tval % MOD)) % MOD
                    if ans >= (1 << 62):
                        ans %= MOD
                curIdx += 1

    ans %= MOD
    print(ans)

if __name__ == "__main__":
    main()
