#include<bits/stdc++.h>

using namespace std;

#define int long long
#define sz(x) x.size()
#define all(x) std::begin(x), std::end(x)

const long long INF = 1e18;

const int LG = 5;

vector<int> g[3005];
unordered_map<int, int> mp;
unordered_map<int, int> mnvalues;

void get_divs(int n, vector<int> &v) {
	for (int i = 1; i * i <= n; ++i) {
		if (n % i == 0) {
			v.emplace_back(i);
			if (n / i != i)
				v.emplace_back(n / i);
		}
	}
}

void dfs(int v, int sum, int price) {
	sum += v;
	price += mp[v];
	if (mnvalues.find(sum) == mnvalues.end()) {
		mnvalues[sum] = price;
	} else {
		mnvalues[sum] = min(mnvalues[sum], price);
	}
	for (auto u : g[v]) {
		dfs(u, sum, price);
	}
}

void solve() {
	mp.clear();
	mnvalues.clear();
	int n, L;
	cin >> n >> L;
	vector<int> x(n);
	for (auto &u : x) {
		cin >> u;
		mp[u] = INF;
		g[u].clear();
	}
	for (int i = 0; i < n; ++i) {
		int tmp;
		cin >> tmp;
		mp[x[i]] = min(tmp, mp[x[i]]);
	}
	sort(all(x));
	x.erase(unique(all(x)), x.end());
	for (int i = 0; i < (int)(x.size()); ++i) {
		for (int j = i + 1; j < (int)(x.size()); ++j) {
			g[x[i]].emplace_back(x[j]);
		}
	}
	for (auto u : x) {
		dfs(u, 0, 0);
	}
	int ans = INF, aL = abs(L);
	vector<int> divs;
	get_divs(aL, divs);
	for (auto d : divs) {
		for (auto u : mnvalues) {
			if (u.first == d) {
				ans = min(ans, u.second);
			} else if (u.first > d) {
				int need = u.first - d;
				if (mnvalues.find(need) != mnvalues.end()) {
					ans = min(ans, mnvalues[need] + u.second);
				}
			}
		}
	}
	if (ans == INF) {
		cout << -1 << endl;
	} else {
		cout << ans << endl;
	}
}

signed main() {
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	cout.tie(0);
	int t;
	cin >> t;
	while (t--)
	solve();
	return 0;
}