#include <bits/stdc++.h>

using namespace std;

std::mt19937_64 rnd(chrono::steady_clock().now().time_since_epoch().count());

bool check(const std::vector<int>& a, const std::vector<int>& b, const std::vector<int>& c) {
    std::set<int> s;
    for (auto& i : a)
        s.insert(i);
    for (auto& i : b)
        s.insert(i);
    for (auto& i : c)
        s.insert(i);
    return s.size() == a.size() + b.size() + c.size();
}

void get(int n) {
    std::vector<std::vector<int>> a(n, std::vector<int>(n));
    std::vector<int> stolb(n), hor(n), d(2);
    for (int i = 0; i < n; ++i)
        for (int j = 0; j < n; ++j) {
            a[i][j] = i * n + j + 1;
            stolb[j] += a[i][j];
            hor[i] += a[i][j];
            if (i == j)
                d[0] += a[i][j];
            if (i + j + 1 == n)
                d[1] += a[i][j];
        }
    int lim = 2e5;
    while (lim && !check(stolb, hor, d)) {
        --lim;
        int i = rnd() % n, j = rnd() % n;
        int i2 = rnd() % n, j2 = rnd() % n;
        int x = a[i][j], y = a[i2][j2];
        stolb[j] -= x - y;
        hor[i] -= x - y;
        stolb[j2] -= y - x;
        hor[i2] -= y - x;
        if (i == j)
            d[0] -= x - y;
        if (i2 == j2)
            d[0] -= y - x;
        if (i + j + 1 == n)
            d[1] -= x - y;
        if (i2 + j2 + 1 == n)
            d[1] -= y - x;
        std::swap(a[i][j], a[i2][j2]);
    }
    if (!lim) {
        std::cout << "No";
        exit(0);
    }
    std::cout << "Yes\n";
    for (int i = 0; i < n; ++i) {
        for (auto& j : a[i])
            std::cout << j << ' ';
        std::cout << '\n';
    }
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(0);
    int n;
    std::cin >> n;
    get(n);
    return 0;
}
