#include <bits/stdc++.h>
using namespace std;

const int INF = 1e9;

int n, q;
vector<int> a;
vector<int> L, R;
vector<int> tree;   // сегдерево максимумов

int mergev(int a, int b) { return max(a, b); }

void build(int v, int tl, int tr) {
    if (tl == tr) {
        tree[v] = 2 * min(L[tl], R[tl]) + 1;
    } else {
        int tm = (tl + tr) / 2;
        build(v*2, tl, tm);
        build(v*2+1, tm+1, tr);
        tree[v] = mergev(tree[v*2], tree[v*2+1]);
    }
}

void update_tree(int v, int tl, int tr, int pos) {
    if (tl == tr) {
        tree[v] = 2 * min(L[pos], R[pos]) + 1;
    } else {
        int tm = (tl + tr) / 2;
        if (pos <= tm) update_tree(v*2, tl, tm, pos);
        else update_tree(v*2+1, tm+1, tr, pos);
        tree[v] = mergev(tree[v*2], tree[v*2+1]);
    }
}

int get_max() { return tree[1]; }

// --- Пересчёт L и R локально ---
void recompute_left(int i) {
    while (i > 0) {
        int old = L[i];
        if (i == 1) L[i] = 0;
        else if (a[i-1] == a[i] - 1) L[i] = L[i-1] + 1;
        else L[i] = 0;
        if (L[i] == old) break;
        update_tree(1, 1, n, i);
        i--;
    }
}

void recompute_right(int i) {
    while (i <= n) {
        int old = R[i];
        if (i == n) R[i] = 0;
        else if (a[i+1] == a[i] - 1) R[i] = R[i+1] + 1;
        else R[i] = 0;
        if (R[i] == old) break;
        update_tree(1, 1, n, i);
        i++;
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    cin >> n;
    a.assign(n+1, 0);
    L.assign(n+1, 0);
    R.assign(n+1, 0);
    tree.assign(4*n+5, 0);

    for (int i = 1; i <= n; i++) cin >> a[i];

    // вычисляем L
    for (int i = 2; i <= n; i++) {
        if (a[i-1] == a[i] - 1) L[i] = L[i-1] + 1;
        else L[i] = 0;
    }

    // вычисляем R
    for (int i = n-1; i >= 1; i--) {
        if (a[i+1] == a[i] - 1) R[i] = R[i+1] + 1;
        else R[i] = 0;
    }

    build(1, 1, n);

    cin >> q;

    cout << get_max() << "\n";

    while (q--) {
        int i, x;
        cin >> i >> x;
        a[i] = x;

        // меняем L и R локально
        recompute_left(i);
        recompute_right(i);

        cout << get_max() << "\n";
    }
    return 0;
}
