﻿#include <iostream>
#include <vector>
#include <algorithm>
#include <numeric>

using namespace std;
using int64 = long long;
static const int MOD = 998244353;

int64 gcdll(int64 a, int64 b) {
    while (b) { int64 t = a % b; a = b; b = t; }
    return a;
}

int64 lcm_bound(int64 a, int64 b) {
    if (a == 0 || b == 0) return 0;
    long long g = gcdll(a, b);
    long long x = a / g;
    if (x > (long long)2e18 / b) return (long long)2e18;
    return x * b;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<int64> a(n + 1);
    for (int i = 1; i <= n; i++) cin >> a[i];

    vector<int64> L(n + 2, 0), R(n + 2, 0);
    for (int i = 1; i <= n; i++) L[i] = gcdll(L[i - 1], a[i]);
    for (int i = n; i >= 1; i--) R[i] = gcdll(R[i + 1], a[i]);

    long long ans = 0;

    vector<pair<long long, int>> cur, nxt;
    cur.reserve(50);
    nxt.reserve(50);

    for (int i = 1; i <= n; i++) {
        cur.clear();
        cur.push_back({ a[i], 1 });
        long long pref = L[i - 1];

        for (int j = i; j <= n; j++) {
            if (j > i) {
                nxt.clear();
                nxt.push_back({ a[j], 1 });
                for (auto& p : cur) {
                    long long l = lcm_bound(p.first, a[j]);
                    if (l > (long long)1e14) l = (long long)1e14;
                    if (nxt.back().first == l) nxt.back().second += p.second;
                    else nxt.push_back({ l, p.second });
                }
                cur.swap(nxt);
            }
            long long suf = R[j + 1];
            for (auto& p : cur) {
                long long g = gcdll(pref, p.first);
                g = gcdll(g, suf);
                ans = (ans + (g % MOD) * p.second) % MOD;
            }
        }
    }

    cout << ans % MOD << "\n";
    return 0;
}
