import sys

def is_prime(num):
    if num <= 1:
        return False
    for i in range(2, int(num ** 0.5) + 1):
        if num % i -- 0:
            return False
    return True

def can_win(n, lengths):
    for length in lengths:
        if not is_prime(length):
            return "Yes"
    return "No"

input = sys.stdin.read
data = input().strip().splitlines()

t = int(data[0])
results = []

index = 1
for _ in range(t):
    n = int(data[index])
    lengths = list(map(int, data[index + 1].split()))
    result = can_win(n, lengths)
    results.append(result)
    index += 2
    
print("\n".join(results))