import sys

# Увеличиваем лимит рекурсии (на всякий случай)
sys.setrecursionlimit(2000)

# Модуль M = 998244353
M = 998244353

# Предварительное вычисление обратных элементов
INV2 = pow(2, M - 2, M) 
INV6 = pow(6, M - 2, M)

def sum_of_range(L, R):
    """Вычисляет сумму чисел от L до R: (R(R+1)/2 - (L-1)L/2) mod M"""
    if L > R:
        return 0
    
    # S(k) = k * (k + 1) / 2
    def S(k):
        # Обязательно берем k по модулю, так как k может быть до 10^12
        k_m = k % M
        return k_m * (k_m + 1) % M * INV2 % M

    return (S(R) - S(L - 1) + M) % M

def sum_of_squares_range(L, R):
    """Вычисляет сумму квадратов от L до R: (R(R+1)(2R+1)/6 - (L-1)L(2L-1)/6) mod M"""
    if L > R:
        return 0
    
    # S(k) = k(k+1)(2k+1) / 6
    def S_sq(k):
        k_m = k % M
        k_plus_1_m = (k_m + 1) % M
        two_k_plus_1_m = (2 * k_m + 1) % M
        
        term = k_m * k_plus_1_m % M * two_k_plus_1_m % M
        return term * INV6 % M

    return (S_sq(R) - S_sq(L - 1) + M) % M

def solve():
    """Основная функция для решения задачи."""
    try:
        # Чтение n
        n = int(sys.stdin.readline())
    except:
        return

    # 1. Часть 1: S_part1 = n^2 * (n + 1) / 2 mod M
    n_m = n % M
    S_part1 = n_m * n_m % M * (n_m + 1) % M * INV2 % M

    # 2. Часть 2: S_part2
    S_part2 = 0
    i = 1
    
    while i <= n:
        # k - частное, R - правая граница
        k = n // i
        R = n // k # R = floor(n/k)
        
        # 3. Вычисление коэффициентов A и B по модулю
        
        # A = -k(k+1)/2 mod M
        k_m = k % M
        k_plus_1_m = (k_m + 1) % M
        A = (-(k_m * k_plus_1_m % M) * INV2) % M
        
        # B = k * (n + 1) mod M
        n_plus_1_m = (n % M + 1) % M
        B = k_m * n_plus_1_m % M
        
        # 4. Вычисление сумм на отрезке [i, R]
        
        # Sum_block = A * sum(j^2) + B * sum(j)
        sum_j = sum_of_range(i, R)
        sum_j_squared = sum_of_squares_range(i, R)
        
        term_A = A * sum_j_squared % M
        term_B = B * sum_j % M
        
        sum_block = (term_A + term_B) % M
        
        S_part2 = (S_part2 + sum_block) % M
        
        # Переход к следующему блоку
        i = R + 1

    # 5. Окончательный результат: S = S_part1 - S_part2 mod M
    result = (S_part1 - S_part2 + M) % M
    
    print(result)

if __name__ == "__main__":
    solve()
