import sys

# Увеличиваем лимит рекурсии для безопасности, хотя в этом коде она не используется
sys.setrecursionlimit(2000)

def solve():
    """
    Решает задачу "Остаток от суммы остатков" за O(sqrt(n)).
    """
    try:
        # Чтение входного числа n
        # n может быть очень большим (до 10^12), поэтому используем int()
        n = int(sys.stdin.readline())
    except:
        # Если ввод пуст или некорректен, можно выйти или использовать тестовое n
        # print("Ошибка чтения n. Используем n=5 для примера.")
        # n = 5 
        return

    # Модуль M = 998244353
    M = 998244353
    
    # 1. Предварительные вычисления (обратные элементы по модулю M)
    
    # Вычисляем 2^{-1} mod M
    INV2 = pow(2, M - 2, M) 
    # Вычисляем 6^{-1} mod M = (2^{-1} * 3^{-1}) mod M
    # INV6 = pow(6, M - 2, M) # Можно напрямую
    # Или через 2^{-1} и 3^{-1}:
    INV3 = pow(3, M - 2, M)
    INV6 = (INV2 * INV3) % M

    def sum_of_range(L, R):
        """Вычисляет сумму чисел от L до R: (R(R+1)/2 - (L-1)L/2) mod M"""
        if L > R:
            return 0
        
        # Сумма до R: R * (R + 1) / 2
        sum_R = (R % M) * ((R % M) + 1) % M * INV2 % M
        
        # Сумма до L-1: (L - 1) * L / 2
        L_minus_1 = (L - 1) % M
        sum_L_minus_1 = L_minus_1 * (L % M) % M * INV2 % M
        
        return (sum_R - sum_L_minus_1 + M) % M

    def sum_of_squares_range(L, R):
        """Вычисляет сумму квадратов от L до R: (R(R+1)(2R+1)/6 - (L-1)L(2L-1)/6) mod M"""
        if L > R:
            return 0
        
        # S(k) = k(k+1)(2k+1) / 6
        def S(k):
            k_m = k % M
            k_plus_1_m = (k_m + 1) % M
            two_k_plus_1_m = (2 * k_m + 1) % M
            
            term = k_m * k_plus_1_m % M * two_k_plus_1_m % M
            return term * INV6 % M

        # Сумма до R
        sum_R = S(R)
        
        # Сумма до L-1
        sum_L_minus_1 = S(L - 1)
        
        return (sum_R - sum_L_minus_1 + M) % M

    # 2. Часть 1: Сумма i * n
    # S_part1 = n^2 * (n + 1) / 2 mod M
    n_m = n % M
    n_squared_m = (n_m * n_m) % M
    n_plus_1_m = (n_m + 1) % M
    
    S_part1 = n_squared_m * n_plus_1_m % M * INV2 % M

    # 3. Часть 2: Вычисление двойной суммы с помощью группировки (O(sqrt(n)))
    # S_part2 = sum_{j=1}^{n} sum_{i=1}^{n} j * floor(i/j)
    
    S_part2 = 0
    # i - это левая граница текущего блока [i, R]
    i = 1
    
    while i <= n:
        # k = floor(n/j) на блоке [i, R]
        k = n // i
        
        # R - правая граница блока
        # R = floor(n/k). Это максимальное j, при котором floor(n/j) = k.
        R = n // k
        
        # 4. Вычисление суммы на блоке [i, R]
        # k = floor(n/j) постоянно на [i, R]
        
        # Нам нужно вычислить: sum_{j=i}^{R} j * [ j * (k(k-1)/2) + k * (n - k*j + 1) ]
        # После упрощения: sum_{j=i}^{R} [ j^2 * A + j * B ]
        
        # A = (k(k-1)/2) - k^2 = (-k^2 - k) / 2 = -k(k+1)/2
        k_m = k % M
        k_plus_1_m = (k_m + 1) % M
        A = (-(k_m * k_plus_1_m % M) * INV2) % M
        
        # B = k * (n + 1)
        B = k_m * ((n % M) + 1) % M
        
        # Sum_block = A * sum(j^2) + B * sum(j)
        sum_j = sum_of_range(i, R)
        sum_j_squared = sum_of_squares_range(i, R)
        
        term_A = A * sum_j_squared % M
        term_B = B * sum_j % M
        
        sum_block = (term_A + term_B) % M
        
        S_part2 = (S_part2 + sum_block) % M
        
        # Переход к следующему блоку
        i = R + 1

    # 5. Окончательный результат
    # S = S_part1 - S_part2 mod M
    result = (S_part1 - S_part2 + M) % M
    
    print(result)

if __name__ == "__main__":
    solve()
