MOD = 998244353

def sum_squares(x):
    # sum_{t=1..x} t^2
    return x * (x + 1) * (2 * x + 1) // 6

def solve():
    n = int(input().strip())
    ans = 0
    T = n * (n + 1) // 2  # sum_{i=1..n} i
    T_mod = T % MOD

    j = 1
    while j <= n:
        m = n // j
        r = n // m  # максимальное j с тем же m

        L, R = j, r
        cnt = R - L + 1

        # суммы j и j^2 на отрезке [L, R]
        S1 = (L + R) * cnt // 2
        S2 = sum_squares(R) - sum_squares(L - 1)

        # по выводу:
        # для каждого j с данным m: S_j = T - j*m*(n+1) + j^2 * m*(m+1)/2
        # суммируем по j в [L,R]:
        term1 = (cnt % MOD) * T_mod % MOD
        term2 = (m % MOD) * ((n + 1) % MOD) % MOD * (S1 % MOD) % MOD
        mm = (m * (m + 1) // 2) % MOD
        term3 = mm * (S2 % MOD) % MOD

        add = (term1 - term2 + term3) % MOD
        ans = (ans + add) % MOD

        j = r + 1

    print(ans % MOD)

if __name__ == "__main__":
    solve()
