import sys
import io

# Устанавливаем ввод/вывод в 'stdin'/'stdout' для корректной работы в средах тестирования
# sys.stdin = io.StringIO(standard_input)
# sys.stdout = sys.__stdout__

def power(a, b, m):
    """Вычисляет (a^b) % m."""
    res = 1
    a %= m
    while b > 0:
        if b & 1:
            res = (res * a) % m
        a = (a * a) % m
        b >>= 1
    return res

def miller_rabin(n):
    """
    Тест Миллера-Рабина для проверки простоты числа n.
    Работает для n до 10^12.
    """
    if n < 2:
        return False
    if n == 2 or n == 3:
        return True
    if n % 2 == 0 or n % 3 == 0:
        return False
    
    # Детерминированный набор основ для n < 2^64 (а 10^12 < 2^64)
    # Основы для n < 3,317,044,064,679,887,385,961,981: 2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37
    # Для n < 10^12 (n < 2^40) достаточно основ 2, 3, 5, 7, 11, 13, 17, 19, 23.
    bases = [2, 3, 5, 7, 11, 13, 17, 19, 23]
    
    d = n - 1
    s = 0
    while d % 2 == 0:
        d //= 2
        s += 1

    for a in bases:
        if a >= n:
            break
        x = power(a, d, n)
        if x == 1 or x == n - 1:
            continue
        
        composite = True
        for _ in range(s - 1):
            x = (x * x) % n
            if x == n - 1:
                composite = False
                break
        
        if composite:
            return False
    
    return True

def get_grundy_value(s):
    """
    Вычисляет Гранди-значение G(s) по упрощенному паттерну.
    G(s) = 0 для простого/1, G(s) = 1 для составного.
    Это упрощение, работающее для данной олимпиадной задачи.
    """
    if s == 1:
        return 0
    
    # Для s > 1
    if miller_rabin(s):
        # s - простое число
        return 0
    else:
        # s - составное число
        return 1

def solve():
    """Основная функция для обработки наборов входных данных."""
    try:
        # Читаем количество тестовых наборов t
        t = int(sys.stdin.readline())
    except Exception:
        return

    results = []

    for _ in range(t):
        try:
            # Читаем количество нитей n
            n = int(sys.stdin.readline())
            
            # Читаем длины нитей s_i
            s_list = list(map(int, sys.stdin.readline().split()))
        except Exception:
            continue
        
        # Вычисляем Ним-сумму (XOR Sum)
        nim_sum = 0
        for s in s_list:
            nim_sum ^= get_grundy_value(s)
            
        # Проверяем выигрышную позицию (N-позиция) для Пети
        if nim_sum != 0:
            results.append("Yes")
        else:
            results.append("No")
            
    sys.stdout.write('\n'.join(results) + '\n')

# Запуск решения
# Поскольку ввод/вывод может быть вставлен в буфер, используем sys.stdin/stdout
solve()
