import sys
import math

input = sys.stdin.readline

t = int(input())
answers = []

for _ in range(t):
    n, L = map(int, input().split())
    L = abs(L)
    xs = list(map(int, input().split()))
    cs = list(map(int, input().split()))

    INF = 10**18
    dp = {}

    for x, c in zip(xs, cs):
        ndp = dp.copy()

        if x in ndp:
            ndp[x] = min(ndp[x], c)
        else:
            ndp[x] = c


        for g, cost in dp.items():
            new_g = math.gcd(g, x)
            new_cost = cost + c
            if new_g in ndp:
                if new_cost < ndp[new_g]:
                    ndp[new_g] = new_cost
            else:
                ndp[new_g] = new_cost

        dp = ndp


    ans = INF
    for g, cost in dp.items():
        if L % g == 0:
            ans = min(ans, cost)

    answers.append(str(ans if ans < INF else -1))

print("\n".join(answers))
