import sys
from collections import deque

input = sys.stdin.readline

n = int(input())
q = deque()

for _ in range(n):
    name, length = input().split()
    q.append([name, int(length)])

m = int(input())
events = []
for _ in range(m):
    t, name, length = input().split()
    events.append((int(t), name, int(length)))

idx = 0
cur_time = 0

while True:

    while idx < m and events[idx][0] == cur_time:
        t, name, length = events[idx]
        q.appendleft([name, length])
        idx += 1

    if not q:
        if idx < m:
            cur_time = events[idx][0]
            continue
        break

    name, length = q.popleft()

    start_time = cur_time
    end_time = start_time + length

    print(name, start_time)


    while idx < m and events[idx][0] < end_time:
        t, ename, elen = events[idx]
        q.appendleft([ename, elen])
        idx += 1

    cur_time = end_time
