#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    if (n == 1 || n == 2) {
        cout << "No\n";
        return 0;
    }

    vector<vector<int>> a(n, vector<int>(n));

    int val = 1;
    for (int i = 0; i < n; i++)
        for (int j = 0; j < n; j++)
            a[i][j] = val++;

    auto sums_ok = [&](vector<vector<int>>& m) {
        unordered_set<long long> S;
        S.reserve(4*n);

        for (int i = 0; i < n; i++) {
            long long s = 0;
            for (int j = 0; j < n; j++) s += m[i][j];
            if (!S.insert(s).second) return false;
        }
        for (int j = 0; j < n; j++) {
            long long s = 0;
            for (int i = 0; i < n; i++) s += m[i][j];
            if (!S.insert(s).second) return false;
        }
        long long s = 0;
        for (int i = 0; i < n; i++) s += m[i][i];
        if (!S.insert(s).second) return false;

        s = 0;
        for (int i = 0; i < n; i++) s += m[i][n-1-i];
        if (!S.insert(s).second) return false;

        return true;
    };

    mt19937 rng(71268721);
    vector<int> order(n);
    iota(order.begin(), order.end(), 0);

    const int MAX_TRY = 2000;
    for (int tt = 0; tt < MAX_TRY; tt++) {
        shuffle(order.begin(), order.end(), rng);

        vector<vector<int>> t(n, vector<int>(n));
        for (int i = 0; i < n; i++)
            t[i] = a[order[i]];

        if (sums_ok(t)) {
            cout << "Yes\n";
            for (int i = 0; i < n; i++) {
                for (int j = 0; j < n; j++)
                    cout << t[i][j] << " ";
                cout << "\n";
            }
            return 0;
        }
    }

    cout << "No\n";
    return 0;
}