from collections import deque


n = int(input())
q = deque()
for _ in range(n):
    name, leng = input().split()
    q.append((name, int(leng)))

m = int(input())
events = []
for _ in range(m):
    time, name, leng = input().split()
    events.append((int(time), name, int(leng)))

curr_time = 0
event_idx = 0

while q or event_idx < m:
    if not q:
        time, name, leng = events[event_idx]
        q.appendleft((name, leng))
        curr_time = max(curr_time, time)
        event_idx += 1
    
    name, leng = q.popleft()
    print(name, curr_time)

    while event_idx < m and events[event_idx][0] <= curr_time + leng:
        time, nname, lleng = events[event_idx]
        q.appendleft((nname, lleng))
        event_idx += 1

    curr_time += leng
