import java.io.*;
import java.util.*;

public class Solution {
    
    static int inv2mod(int n) {
		return (n + 1) / 2;
	}
    
	static int[][] solveOdd(int n) {
		int[][] a = new int[n][n];
		
		int inv = inv2mod(n);
		
		for (int i = 0; i < n; i++) {
			for (int j = 0; j < n; j++) {
				a[i][j] = ((i + j) * inv) % n;
			}
		}

		return a;
	}

	static int[][] solveEven(int n) {
		int h = n / 2;

		int[][] a = new int[n][n];

		for (int i = 0; i < n; i++) {
			for (int j = 0; j < n; j++) {
				a[i][j] = -1;
			}
		}

		boolean[][] use = new boolean[n][n];

		for (int i = 0; i < n; i++) {
			int j = i / 2;
			int j1 = 2 * j;
			int j2 = 2 * j + 1;

			int v1 = ((i + 1) % n / 2 + j) % h;
			int v2 = v1 + h;

			if ((i == j1 && j1 == v2) || (i == j2 && j2 == v1)) {

				v2 ^= v1;
				v1 ^= v2;
				v2 ^= v1;
			}

			a[i][j1] = v1;
			a[i][j2] = v2;

			use[j1][v1] = true;
			use[j2][v2] = true;
		}

		for (int i = 0; i < n; i++) {
			for (int j = 0; j < h; j++) {
				int j1 = 2 * j;
				int j2 = 2 * j + 1;

				if (i == j1 || i == j2) {
					continue;
				}

				int v1 = ((i + 1) % n / 2 + j) % h;
				int v2 = v1 + h;

				if (use[j1][v1] || use[j2][v2]) {
					v2 ^= v1;
					v1 ^= v2;
					v2 ^= v1;
				}

				a[i][j1] = v1;
				a[i][j2] = v2;

				use[j1][v1] = true;
				use[j2][v2] = true;
			}
		}

		return a;

	}

	static int[][] solve(int n) {
		if (n == 2) {
			return new int[][] { { -2 } }; // -2 + 1 = -1
		}

		if (n % 2 == 0) {
			return solveEven(n);
		} else {
			return solveOdd(n);
		}
	}

	void run(InOutStream inOutStream) {
		int n = inOutStream.nextInt();
		int[][] a = solve(n);

		for (int[] row : a) {
			for (int v : row) {
				inOutStream.print(v + 1);
				inOutStream.print(' ');
			}
			inOutStream.println();
		}
	}

	static class InOutStream extends PrintWriter {
		private final BufferedReader reader;

		private StringTokenizer tokenizer = new StringTokenizer("");

		public InOutStream(InputStream input, OutputStream output) throws FileNotFoundException {
			super(output);
			this.reader = new BufferedReader(new InputStreamReader(input));
		}

		String next() {
			while (!tokenizer.hasMoreTokens()) {
				tokenizer = new StringTokenizer(nextLine());
			}
			return tokenizer.nextToken();
		}

		int nextInt() {
			return Integer.parseInt(next());
		}

		String nextLine() {
			try {
				return reader.readLine();
			} catch (IOException err) {
				return null;
			}
		}

		@Override
		public void close() {
			try {
				reader.close();
			} catch (IOException e) {
				super.setError();
			}
			super.close();
		}
	}

	public static void main(String[] args) throws FileNotFoundException {
		Solution solution = new Solution();
		try (InOutStream inOutStream = new InOutStream(System.in, System.out)) {
			solution.run(inOutStream);
		}
	}

}
