import java.io.*;
import java.util.*;

public class SolutionSlow {

	static int inv2mod(int n) {
		return (n + 1) / 2;
	}

	static int[][] solveOdd(int n) {
		int[][] a = new int[n][n];

		int inv = inv2mod(n);

		for (int i = 0; i < n; i++) {
			for (int j = 0; j < n; j++) {
				a[i][j] = ((i + j) * inv) % n;
			}
		}

		return a;
	}

	static boolean solveRec(int n, int[][] a) {
		int fx = -1, fy = -1;
		int fc = -1;
		boolean[] fu = new boolean[n];

		for (int x = 0; x < n; x++) {
			for (int y = 0; y < n; y++) {
				if (a[x][y] != -1) {
					continue;
				}

				boolean[] use = new boolean[n];

				for (int i = 0; i < n; i++) {
					if (a[i][y] != -1) {
						use[a[i][y]] = true;
					}

					if (a[x][i] != -1) {
						use[a[x][i]] = true;
					}
				}

				int cnt = 0;

				for (boolean b : use) {
					if (b) {
						cnt++;
					}
				}

				if (cnt == n) {
					return false;
				}

				if (cnt > fc) {
					fc = cnt;
					fx = x;
					fy = y;
					fu = use;
				}
			}
		}

		if (fx == -1 || fy == -1) {
			return true;
		}

		for (int i = 0; i < n; i++) {
			if (fu[i]) {
				continue;
			}

			a[fx][fy] = i;

			if (solveRec(n, a)) {
				return true;
			}
		}

		a[fx][fy] = -1;

		return false;
	}

	static int[][] solveEven(int n) {
		int[][] a = new int[n][n];

		for (int i = 0; i < n; i++) {
			for (int j = 0; j < n; j++) {
				a[i][j] = -1;
			}
			a[i][i] = i;
		}

		solveRec(n, a);

		return a;

	}

	static int[][] solve(int n) {
		if (n == 2) {
			return new int[][] { { -2 } }; // -2 + 1 = -1
		}

		if (n % 2 == 0) {
			return solveEven(n);
		} else {
			return solveOdd(n);
		}
	}

	void run(InOutStream inOutStream) {
		int n = inOutStream.nextInt();
		int[][] a = solve(n);

		for (int[] row : a) {
			for (int v : row) {
				inOutStream.print(v + 1);
				inOutStream.print(' ');
			}
			inOutStream.println();
		}
	}

	static class InOutStream extends PrintWriter {
		private final BufferedReader reader;

		private StringTokenizer tokenizer = new StringTokenizer("");

		public InOutStream(InputStream input, OutputStream output) throws FileNotFoundException {
			super(output);
			this.reader = new BufferedReader(new InputStreamReader(input));
		}

		String next() {
			while (!tokenizer.hasMoreTokens()) {
				tokenizer = new StringTokenizer(nextLine());
			}
			return tokenizer.nextToken();
		}

		int nextInt() {
			return Integer.parseInt(next());
		}

		String nextLine() {
			try {
				return reader.readLine();
			} catch (IOException err) {
				return null;
			}
		}

		@Override
		public void close() {
			try {
				reader.close();
			} catch (IOException e) {
				super.setError();
			}
			super.close();
		}
	}

	public static void main(String[] args) throws FileNotFoundException {
		SolutionSlow solution = new SolutionSlow();
		try (InOutStream inOutStream = new InOutStream(System.in, System.out)) {
			solution.run(inOutStream);
		}
	}

}
