#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ull = unsigned long long;
using ld = long double;

const int MOD = 998244353;
struct R {
    int r;
    R(ll r = 0): r(r % MOD) {}

    R operator+ (const R& o) const {
        int res = r + o.r;
        if (res >= MOD) {
            return res - MOD;
        } else {
            return res;
        }
    }
    R operator- (const R& o) const {
        int res = r - o.r;
        if (res < 0) {
            return res + MOD;
        } else {
            return res;
        }
    }
    R operator* (const R& o) const {
        ll res = 1ll * r * o.r;
        return res % MOD;
    }

    R operator/ (const R& o) const {
        return binpow(o, MOD - 2) * r;
    }

    R binpow(R a, int n) const {
        if (!n) {
            return 1;
        }
        if (n % 2) {
            return a * binpow(a, n - 1);
        } else {
            return binpow(a * a, n / 2);
        }
    }
};


const R DEL2 = R(1) / 2;
const R DEL6 = R(1) / 6;

R formula2(R i) {
    return i * (i + 1) * (i * 2 + 1) * DEL6;
}
signed main() {
    ios_base::sync_with_stdio(0), cin.tie(0), cout.tie(0);
    ll n;
    cin >> n;

    R res = 0;
    ll iter = sqrt(n);
    ll J = n / max(iter + 1, 1ll);

    for (ll s = 0; s <= iter; s++) {
        R j = n / max(s + 1, 1ll);
        res = res + (formula2(j) - j * (j + 1) * DEL2) * DEL2;

        R count = n / max(s, 1ll) - n / max(s + 1, 1ll);
        res = res + R(n) * DEL2 * count +
              R(n) * R(n) * DEL2 * count -
              R(n) * s * (n / max(s, 1ll) + n / max(s + 1, 1ll) + 1) * count * DEL2 -
              R(s) * DEL2 * (n / max(s, 1ll) + n / max(s + 1, 1ll) + 1) * count * DEL2 +
              R(s) * R(s) * DEL2 * (formula2(n / max(s, 1ll)) - formula2(n / max(s + 1, 1ll)));

        j = J;
        res = res - (formula2(j) - j * (j + 1) * DEL2) * DEL2;
    }

    for (ll j = 1; j <= J; j++) {
        res = res + R(n / j % MOD) * (R(j) * (j - 1) * DEL2)
              + (R(n % j % MOD) * (R(n % j % MOD) + 1) * DEL2);
    }

    cout << res.r;
    return 0;
}