#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ull = unsigned long long;
using ld = long double;

const int MOD = 998244353;
struct R {
    int r;
    R(int r = 0): r(r) {}

    R operator+ (const R& o) const {
        int res = r + o.r;
        if (res >= MOD) {
            return res - MOD;
        } else {
            return res;
        }
    }
    R operator- (const R& o) const {
        int res = r - o.r;
        if (res < 0) {
            return res + MOD;
        } else {
            return res;
        }
    }
    R operator* (const R& o) const {
        ll res = 1ll * r * o.r;
        return res % MOD;
    }

    R operator/ (const R& o) const {
        return binpow(o, MOD - 2) * r;
    }

    R binpow(R a, int n) const {
        if (!n) {
            return 1;
        }
        if (n % 2) {
            return a * binpow(a, n - 1);
        } else {
            return binpow(a * a, n / 2);
        }
    }
};

R formula2(R i) {
    return i * (i + 1) * (i * 2 + 1) / 6;
}
signed main() {
    ios_base::sync_with_stdio(0), cin.tie(0), cout.tie(0);
    ll n;
    cin >> n;

    R res = 0;
    for (ll j = 1; j <= n; j++) {
        res = res + R(n / j % MOD) * (R(j) * (j - 1) / 2)
                + (R(n % j % MOD) * (R(n % j % MOD) + 1) / 2) ;
    }

    cout << res.r;
    return 0;
}