#include <bits/stdc++.h>
using namespace std;

using int64 = long long;
using i128 = __int128_t;

const long long MOD = 998244353;

// умножение по модулю с защитой от переполнения
long long mul_mod(long long a, long long b) {
    return (long long)((i128)a * b % MOD);
}
long long add_mod(long long a, long long b) {
    long long s = a + b;
    if (s >= MOD) s -= MOD;
    return s;
}
long long sub_mod(long long a, long long b) {
    long long s = a - b;
    if (s < 0) s += MOD;
    return s;
}

// быстрый бинпауэр по модулю
long long modpow(long long a, long long e) {
    long long r = 1 % MOD;
    while (e > 0) {
        if (e & 1) r = mul_mod(r, a);
        a = mul_mod(a, a);
        e >>= 1;
    }
    return r;
}

// сумма 1..x по модулю
long long sum1_upto(long long x, long long inv2) {
    long long xm = x % MOD;
    long long res = mul_mod(xm, add_mod(xm,1));
    res = mul_mod(res, inv2);
    return res;
}

// сумма квадратов 1..x по модулю
long long sum2_upto(long long x, long long inv2, long long inv3) {
    // x(x+1)(2x+1)/6. 1/6 = (1/2)*(1/3)
    long long xm = x % MOD;
    long long a = xm;
    long long b = add_mod(xm,1);
    long long c = ( (2*xm)%MOD + 1 ) % MOD;
    long long res = mul_mod(a,b);
    res = mul_mod(res,c);
    // делим на 6: сначала /2 потом /3
    res = mul_mod(res, inv2);
    res = mul_mod(res, inv3);
    return res;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    long long n;
    if (!(cin >> n)) return 0;
    
    const long long inv2 = modpow(2, MOD-2); // 1/2 mod M
    const long long inv3 = modpow(3, MOD-2); // 1/3 mod M
    
    long long ansA = 0;
    long long ansB = 0;
    
    for (long long i = 1; i <= n; ) {
        long long q = n / i;
        long long R = n / q;
        long long L = i;
        
        // S1 = sum j, S2 = sum j^2 на [L,R]
        long long S1 = sub_mod(
            sum1_upto(R, inv2),
            sum1_upto(L-1, inv2)
        );
        long long S2 = sub_mod(
            sum2_upto(R, inv2, inv3),
            sum2_upto(L-1, inv2, inv3)
        );
        
        long long cnt = (R - L + 1) % MOD;
        
        long long qmod = q % MOD;
        long long nmod = n % MOD;
        long long n1mod = (n + 1) % MOD;
        long long two_n_plus_1 = ( (2 % MOD)*nmod % MOD + 1 ) % MOD;
        
        // A_range = q/2 * (S2 - S1)
        long long diff = sub_mod(S2, S1);
        long long A_range = mul_mod(qmod, mul_mod(inv2, diff));
        ansA = add_mod(ansA, A_range);
        
        // B_range = 1/2 * [ n(n+1)*cnt - q(2n+1)*S1 + q^2 * S2 ]
        long long term_const = mul_mod(nmod, n1mod); // n(n+1)
        long long t1 = mul_mod(term_const, cnt);
        long long t2 = mul_mod(mul_mod(qmod, two_n_plus_1), S1);
        long long t3 = mul_mod(mul_mod(qmod, qmod), S2);
        
        long long inside = t1;
        inside = sub_mod(inside, t2);
        inside = add_mod(inside, t3);
        
        long long B_range = mul_mod(inv2, inside);
        ansB = add_mod(ansB, B_range);
        
        i = R + 1;
    }
    
    long long answer = add_mod(ansA, ansB);
    cout << answer % MOD << "\n";
    return 0;
}
