#include <bits/stdc++.h>
using namespace std;

using i64 = long long;
using i128 = __int128_t;

const i64 MOD = 998244353;

i64 addmod(i64 a, i64 b){ a+=b; if(a>=MOD) a-=MOD; return a; }
i64 submod(i64 a, i64 b){ a-=b; if(a<0) a+=MOD; return a; }
i64 mulmod(i64 a, i64 b){ return (i64)((i128)a*b % MOD); }

i64 pw(i64 a, i64 e){
    i64 r=1;
    while(e){
        if(e&1) r=mulmod(r,a);
        a=mulmod(a,a);
        e>>=1;
    }
    return r;
}

// S1(x) = sum_{k=1}^x k
i64 S1(i64 x){
    x%=MOD;
    static const i64 inv2 = (MOD+1)/2;
    return mulmod(mulmod(x, addmod(x,1)), inv2);
}
// S2(x) = sum_{k=1}^x k^2
i64 S2(i64 x){
    x%=MOD;
    static const i64 inv6 = pw(6, MOD-2);
    i64 a = mulmod(x, addmod(x,1));
    i64 b = ( (2*x)%MOD + 1 ) % MOD;
    return mulmod(mulmod(a,b), inv6);
}
// range sums
i64 sum_j(i64 L, i64 R){
    if(L>R) return 0;
    return submod(S1(R), S1(L-1));
}
i64 sum_j2(i64 L, i64 R){
    if(L>R) return 0;
    return submod(S2(R), S2(L-1));
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    long long n;
    if(!(cin>>n)) return 0;

    const i64 inv2 = (MOD+1)/2;
    i64 N = (n % MOD);
    i64 NNpN = mulmod(N, addmod(N,1)); // n^2 + n mod MOD

    i64 ans = 0;
    for(long long L=1; L<=n; ){
        long long q = n / L;
        long long R = n / q; // максимальный j с таким же q

        i64 m = ( (R - L + 1) % MOD );
        i64 S1rng = sum_j(L,R);
        i64 S2rng = sum_j2(L,R);

        i64 q_mod = q % MOD;
        i64 q2_mod = mulmod(q_mod, q_mod);

        // term = 1/2 * ( q*(S2 - S1) + m*(n^2+n) - (2nq+q)*S1 + q^2*S2 )
        i64 partA = mulmod(q_mod, submod(S2rng, S1rng));
        i64 partB = mulmod(m, NNpN);
        i64 two_n_q_plus_q = addmod( mulmod( (2* (N%MOD))%MOD, q_mod ), q_mod ); // (2nq + q) mod
        i64 partC = mulmod(two_n_q_plus_q, S1rng);
        i64 partD = mulmod(q2_mod, S2rng);

        i64 segment = partA;
        segment = addmod(segment, partB);
        segment = submod(segment, partC);
        segment = addmod(segment, partD);
        segment = mulmod(segment, inv2);

        ans = addmod(ans, segment);
        L = R + 1;
    }

    cout << ans % MOD << '\n';
    return 0;
}
