#include "testlib.h"
#include "constants.h"
#include <bits/stdc++.h>

using namespace std;

using ll = long long;

template<typename T>
T get_opt(const string &key, const T &d) { return has_opt(key) ? opt<T>(key) : d; }

static const int PRIME_POOL_ALL[] = {
        2, 3, 5, 7, 11, 13, 17, 19, 23, 29,
        31, 37, 41, 43, 47, 53, 59, 61, 67, 71,
        73, 79, 83, 89, 97, 101, 103, 107, 109, 113,
        127, 131, 137, 139, 149, 151, 157, 163, 167, 173,
        179, 181, 191, 193, 197, 199, 211, 223, 227, 229,
        233, 239, 241, 251, 257, 263, 269, 271, 277, 281
};
static const int PRIME_POOL_ALL_SZ = (int) (sizeof(PRIME_POOL_ALL) / sizeof(PRIME_POOL_ALL[0]));

static bool feasible(const vector<int> &P, int maxX) {
    if (P.empty()) return false;
    int mn = *min_element(P.begin(), P.end());
    ll bound = 1LL * maxX * mn;
    ll D = 1;
    for (int p: P) {
        if (p <= 0) return false;
        if (D > bound / p) return false;
        D *= p;
    }
    return true;
}

static int max_k_possible(const vector<int> &cand, int maxX) {
    ll D = 1;
    int mn = INT_MAX;
    int K = 0;
    for (int p: cand) {
        int mn2 = (K == 0) ? p : min(mn, p);
        ll bound2 = 1LL * maxX * mn2;
        if (D <= bound2 / p) {
            D *= p;
            mn = mn2;
            ++K;
        } else break;
    }
    return max(0, K);
}

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    int t = get_opt("t", 1);
    int maxX = get_opt("X", constants::MAX_X);
    int C = get_opt("C", constants::MAX_C);
    int noise = get_opt("noise", 0);
    int Kwant = get_opt("k", 5);
    bool shuffleAll = get_opt("shuffle", true);
    int Xval = get_opt("goal", 1);
    int poolSize = get_opt("pool", 25);
    int tries = get_opt("tries", 2000);

    poolSize = max(1, min(poolSize, PRIME_POOL_ALL_SZ));
    vector<int> pool(PRIME_POOL_ALL, PRIME_POOL_ALL + poolSize);

    vector<int> pool_sorted = pool;
    sort(pool_sorted.begin(), pool_sorted.end());
    int Kmax = max_k_possible(pool_sorted, maxX);

    Kwant = max(1, min(Kwant, Kmax));

    cout << t << "\n";
    for (int tc = 0; tc < t; ++tc) {
        vector<int> primes;
        primes.reserve(Kwant);
        bool ok_pick = false;
        for (int att = 0; att < tries; ++att) {
            auto perm = rnd.perm((int) pool.size());
            primes.clear();
            for (int i = 0; i < Kwant; ++i) primes.push_back(pool[perm[i]]);
            sort(primes.begin(), primes.end());
            if (feasible(primes, maxX)) {
                ok_pick = true;
                break;
            }
        }
        if (!ok_pick) {
            primes.assign(pool_sorted.begin(), pool_sorted.begin() + Kwant);
        }

        ll D = 1;
        for (int p: primes) {
            D *= p;
        }

        vector<pair<int, int>> items;
        items.reserve(Kwant + noise);

        for (int p: primes) {
            ll xi = D / p;
            int x_print = (int) max(1LL, min((ll) maxX, xi));
            items.emplace_back(x_print, rnd.next(constants::MAX_C / 3 * 2, constants::MAX_C));
        }

        for (int i = 0; i < noise; ++i) {
            int x_noise;
            if (D <= (ll) maxX) x_noise = (int) D;
            else {
                int idx = rnd.next(0, (int) primes.size() - 1);
                ll xi = D / primes[idx];
                x_noise = (int) max(1LL, min((ll) maxX, xi));
            }
            int cc = 1 + rnd.next(0, min(1000, constants::MAX_C));
            items.emplace_back(x_noise, cc);
        }

        if (shuffleAll) {
            auto p = rnd.perm((int) items.size());
            vector<pair<int, int>> tmp(items.size());
            for (int i = 0; i < (int) items.size(); ++i) tmp[i] = items[p[i]];
            items.swap(tmp);
        }

        int n = (int) items.size();
        cout << n << " " << Xval << "\n";
        for (int i = 0; i < items.size(); i++) {
            int x = max(1, min(items[i].first, maxX));
            cout << x;
            if (i != n - 1) cout << ' ';
        }
        cout << '\n';
        for (int i = 0; i < items.size(); i++) {
            int c = max(1, min(items[i].second, constants::MAX_C));
            cout << c;
            if (i != n - 1) cout << ' ';
        }
        cout << '\n';
    }
    return 0;
}
