#include "testlib.h"
#include <bits/stdc++.h>
using namespace std;

int main(int argc, char* argv[]) {
    registerValidation(argc, argv);

    const long long MAX_D = (long long)1e12;
    const int MAX_N = 50;
    const int MAX_M = 500;
    const int MAX_T = 50;

    int T = inf.readInt(1, MAX_T, "t");
    inf.readEoln();

    for (int tc = 1; tc <= T; ++tc) {
        set<pair<int,int>> edges;
        int n = inf.readInt(2, MAX_N, "n");
        inf.readSpace();
        int m = inf.readInt(n - 1, n * (n - 1) /2, "m");
        inf.readSpace();
        long long l = inf.readLong(1, 1'000'000'000LL, "l");
        inf.readEoln();

        vector<vector<int>> g(n + 1);

        for (int i = 0; i < m; i++) {
            int u = inf.readInt(1, n, "u_i");
            inf.readSpace();
            int v = inf.readInt(1, n, "v_i");
            ensuref(u != v, "Self-loops are not allowed (u_i != v_i)");
            pair<int,int> e = {min(u,v), max(u,v)};
            ensuref(!edges.count(e), "Multiple edges between %d and %d are not allowed", u, v);
            edges.insert(e);
            inf.readSpace();

            long long w = inf.readLong(-1, 1000'000'000LL, "w_i");
            if (w == 0)
                ensuref(false, "Edge weight cannot be zero.");
            if (w != -1) {
                ensuref(w >= 1, "Known weight must be positive.");
                ensuref(w <= l, "Known weight must be at most l.");
            }
            inf.readEoln();

            // Добавляем в граф для проверки связности
            g[u].push_back(v);
            g[v].push_back(u);
        }

        vector<long long> d(n);
        for (int i = 0; i < n; i++) {
            d[i] = inf.readLong(0, MAX_D, "d_v");
            if (i + 1 < n)
                inf.readSpace();
        }
        inf.readEoln();

        //ensuref(d[0] == 0, "d_1 must be 0");

        // --- Проверка связности ---
        vector<int> vis(n + 1, 0);
        queue<int> q;
        q.push(1);
        vis[1] = 1;
        int cnt = 0;
        while (!q.empty()) {
            int u = q.front(); q.pop();
            cnt++;
            for (int v : g[u]) if (!vis[v]) {
                vis[v] = 1;
                q.push(v);
            }
        }
        ensuref(cnt == n, "Graph must be connected (test %d)", tc);
    }

    inf.readEof();
}

