#include <bits/stdc++.h>

#include "testlib.h"

using namespace std;

struct Event {
    long long t;
    string name;
    long long len;
};

int main(int argc, char* argv[]) {
    registerGen(argc, argv, 1);

    long long N = opt<long long>(1, 3);
    long long Mper = opt<long long>(2, 3);
    long long baseLen = opt<long long>(3, 5);

    vector<pair<string, long long>> base;
    for (long long i = 0; i < N; ++i) {
        int L = 3 + (int)(i % 3);
        string name = rnd.next("[A-Za-z]{" + toString(L) + "}");
        long long len = baseLen + i;
        base.emplace_back(name, len);
    }

    vector<Event> events;
    long long pref = 0;
    for (long long i = 0; i < N; ++i) {
        pref += base[(size_t)i].second;
        for (long long j = 0; j < Mper; ++j) {
            int L = 4 + (int)(j % 3);
            string ename = rnd.next("[A-Za-z]{" + toString(L) + "}");
            long long elen = baseLen;
            events.push_back({pref, ename, elen});
        }
    }

    stable_sort(events.begin(), events.end(),
                [](const Event& a, const Event& b) { return a.t < b.t; });

    println(N);
    for (auto& p : base) {
        cout << p.first << ' ' << p.second << '\n';
    }
    println((int)events.size());
    for (auto& e : events) {
        cout << e.t << ' ' << e.name << ' ' << e.len << '\n';
    }
    return 0;
}
