#include "testlib.h"
#include "constants.h"

using namespace std;

template<typename T>
T get_opt(const string &key, const T &def) {
    return has_opt(key) ? opt<T>(key) : def;
}

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    const int n_max_default = constants::MAX_N;
    const long long min_default = 2;
    const long long max_default = constants::MAX_S;

    int n_max = get_opt("n", n_max_default);
    auto min_val = get_opt("min", min_default);
    auto max_val = get_opt("max", max_default);

    if (n_max < 1) n_max = 1;
    if (min_val < 1) min_val = 2;
    if (max_val < min_val) std::swap(min_val, max_val);

    vector<vector<long long>> tests;

    int sum_n = 0;
    int tries = 1000;

    while (tests.size() < constants::MAX_T && sum_n < constants::SUM_N_LIMIT && tries--) {
        int remaining = constants::SUM_N_LIMIT - sum_n;
        if (remaining <= 0) break;

        int cur_n = rnd.next(1, min(n_max, remaining));

        vector<long long> s;
        s.reserve(cur_n);
        for (int i = 0; i < cur_n; ++i) {
            long long x = rnd.next(min_val, max_val);
            s.push_back(x);
        }

        tests.push_back(std::move(s));
        sum_n += cur_n;
    }

    cout << tests.size() << '\n';
    for (const auto &v: tests) {
        cout << (int) v.size() << '\n';
        for (int i = 0; i < (int) v.size(); ++i) {
            if (i) cout << ' ';
            cout << v[i];
        }
        cout << '\n';
    }
    return 0;
}
