#include <iostream>
#include <iomanip>
#include <vector>
#include <string>
#include <map>
#include <set>
#include <deque>
#include <algorithm>
#include <cmath>
#include <random>
#include <unordered_map>
#include <unordered_set>
#include <bitset>

using namespace std;
typedef long long ll;
typedef long double ld;
typedef unsigned long long ull;

const ll M = 1e9 + 7;
const ll M1 = 1e9 + 9;
const ll P = 239;
const ll P1 = 137;
const ll INF = 1e9 + 7;
const ll INFll = 2e18;
const ld EPS = 1e-10;
const ld PI = atan2(0, -1);

struct Point {
	ld x, y;
	Point(ld x1 = 0, ld y1 = 0) {
		x = x1;
		y = y1;
	}
};

struct Vector {
	ld x, y, len_2;
	ld len;
	Vector(ld x1 = 0, ld y1 = 0) {
		x = x1;
		y = y1;
		len_2 = x * x + y * y;
		len = sqrtl(len_2);
	}
};

istream& operator >>(istream& in, Point& a) {
	in >> a.x >> a.y;
	return in;
}

ostream& operator <<(ostream& out, Point& a) {
	out << a.x << a.y;
	return out;
}

Vector operator -(Point B, Point A) {
	return Vector(B.x - A.x, B.y - A.y);
}

Vector operator +(Point A, Point B) {
	return Vector(A.x + B.x, A.y + B.y);
}

ll operator *(Vector a, Vector b) {
	return a.x * b.x + a.y * b.y;
}

ll operator ^(Vector a, Vector b) {
	return a.x * b.y - a.y * b.x;
}

struct Line {
	ld a, b, c;
	Point A, B;
	Vector ab;
	Line(Point C = Point(0, 0), Point D = Point(0, 1), ld a1 = 0, ld b1 = 1, ld c1 = 0) {
		a = a1;
		b = b1;
		c = c1;
		if (a == 0) {
			A = { 0, -c1 / b1 };
			B = { 1, -(c1 + a1) / b1 };
		}
		else {
			A = { -c1 / a1, 0 };
			B = { (-c1 + b1) / a1, 1 };
		}
		ab = B - A;
		Vector cd = D - C;
		if (fabs(c) < EPS && fabs(a) < EPS && fabs(b - 1) < EPS) {
			ab = cd;
			A = C;
			B = D;
			a = C.y - D.y;
			b = D.x - C.x;
			c = -a * C.x - b * C.y;
		}
	}
};

mt19937 rnd(time(0));

int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);

	//cout << fixed << setprecision(20);

	//freopen("i.txt", "r", stdin), freopen("o.txt", "w", stdout);

	int n, x, y;
	cin >> n;
	map<int, int> ax, ay;
	vector<pair<int, int>> a(n);
	for (int i = 0; i < n; ++i) {
		cin >> x >> y;
		ax[x]++;
		ay[y]++;
		a[i] = { x, y };
	}
	sort(a.begin(), a.end());
	vector<int> ansx, ansy;
	int chx = 0, chy = 0;
	for (auto [k, v] : ax) {
		if (chx < v) {
			ansx = { k };
			chx = v;
		}
		else if (chx == v) {
			ansx.push_back(k);
		}
	}
	for (auto [k, v] : ay) {
		if (chy < v) {
			ansy = { k };
			chy = v;
		}
		else if (chy == v) {
			ansy.push_back(k);
		}
	}
	int chx1 = ansx.size();
	int chy1 = ansy.size();

	map<int, int> ax1, ay1;
	ll cnt = 0;
	for (auto [x, y] : a) {
		if (ax[x] == chx && ay[y] == chy) {
			cnt++;
			ax1[x]++;
			ay1[y]++;
		}
	}
	if (cnt == chx1 * 1ll * chy1) {
		cout << ansx.back() << " " << ansy.back();
		return 0;
	}
	int x_a = -1, y_a = -1;
	for (auto x : ansx) {
		if (ax1[x] != ax[x]) {
			x_a = x;
			break;
		}
	}
	for (auto y : ansy) {
		if (!binary_search(a.begin(), a.end(), make_pair(x_a, y))) {
			y_a = y;
			break;
		}
	}
	cout << x_a << " " << y_a;


	/*map<int, int> cou;
	for (auto xy : a) {
		int x = xy.first;
		for (auto y : xy.second)
			if (a[x].find(y) != a[x].end()) cou[x]++;
	}
	int ransx = -1;
	for (auto el : cou)
		if (el.second < ansy.size()) {
			ransx = el.first;
			break;
		}
	if (ransx == -1) {
		cout << ansx[0] << ' ' << ansy[0] << '\n';
		return 0;
	}

	for (auto y : ansy)
		if (a[ransx].find(y) == a[x].end()) {
			cout << ransx << ' ' << y << '\n';
			return 0;
		}*/
}


