﻿using System;
using System.Linq;
using System.Numerics;
using System.Drawing;
using System.Collections;
using System.Collections.Generic;

namespace Olymp
{
    class Program
    {
        static void Main(string[] args)
        {
            string[] parts = Console.ReadLine().Split();
            BigInteger s = BigInteger.Parse(parts[0]),
                       c = BigInteger.Parse(parts[1]);
            int digits = parts[0].Length;
            BigInteger pow = 1;
            for (int i = 0; i < digits / 2 + 1; i++)
            {
                var p1 = BigInteger.DivRem(s, pow, out var p2);
                pow *= 10;
                if (c * p2 == p1)
                {
                    Console.WriteLine(p1 + " " + p2);
                }
            }
        }

        #region InputHelpers
        static string Input() => Console.ReadLine();
        static long GetOne() => long.Parse(Console.ReadLine());
        static (long, long) GetTwo()
        {
            string[] parts = Console.ReadLine().Split();
            return (long.Parse(parts[0]), long.Parse(parts[1]));
        }
        static (long, long, long) GetThree()
        {
            string[] parts = Console.ReadLine().Split();
            return (long.Parse(parts[0]), long.Parse(parts[1]), long.Parse(parts[2]));
        }
        static long[] GetN() => Array.ConvertAll(Console.ReadLine().Split(), long.Parse);
        static T Print<T>(T arg)
        {
            Console.WriteLine(arg);
            return arg;
        }
        #endregion
    }
}
