﻿//#pragma GCC optimize("Ofast")
//#pragma GCC
#include <iostream>
#include <iomanip>
#include <cstdlib>
#include <cstdio>
#include <string>
#include <vector>
#include <map>
#include <set>
#include <unordered_map>
#include <unordered_set>
#include <queue>
#include <deque>
#include <cmath>
#include <numeric>
#include <algorithm>
#include <ctime>
#include <chrono>
#include <random>
#include <functional>
#include <stack>
#include <cassert>
#include <climits>

using namespace std;
using ll = long long;

struct segtree {
    struct node {
        ll set;
        ll sum;
    };

    ll NO_OPERATION = LLONG_MAX;
    ll NEUTRAL_ELEMENT = 0;

    vector<node>tree;
    int size;

    ll op_modify(ll a, ll b, ll len) {
        if (b == NO_OPERATION) return a;
        return b;
    }

    ll op_sum(ll a, ll b) {
        return a + b;
    }

    segtree(int n) {
        size = 1;
        while (size < n) size *= 2;
        tree.resize(2 * size - 1);
    }

    void propagate(int x, int lx, int rx) {
        if (tree[x].set == NO_OPERATION || rx - lx == 1) {
            return;
        }
        int m = (lx + rx) / 2;
        tree[x * 2 + 1].set = op_modify(tree[x * 2 + 1].set, tree[x].set, 1);
        tree[x * 2 + 1].sum = op_modify(tree[x * 2 + 1].set, tree[x].set, m - lx);
        tree[x * 2 + 2].set = op_modify(tree[x * 2 + 2].set, tree[x].set, 1);
        tree[x * 2 + 2].sum = op_modify(tree[x * 2 + 2].set, tree[x].set, rx - m);
        tree[x].set = NO_OPERATION;
    }

    void modify(int l, int r, int v, int x, int lx, int rx) {
        propagate(x, lx, rx);
        if (lx >= r || rx <= l) {
            return;
        }
        if (lx >= l && rx <= r) {
            tree[x].sum = op_modify(tree[x].sum, v, rx - lx);
            tree[x].set = op_modify(tree[x].set, v, 1);
            return;
        }
        int m = (lx + rx) / 2;
        modify(l, r, v, x * 2 + 1, lx, m);
        modify(l, r, v, x * 2 + 2, m, rx);
        tree[x].sum = op_sum(tree[x * 2 + 1].sum, tree[x * 2 + 2].sum);
    }
    void modify(int l, int r, int v) {
        modify(l, r, v, 0, 0, size);
    }

    ll get(int l, int r, int x, int lx, int rx) {
        propagate(x, lx, rx);
        if (lx >= r || rx <= l) {
            return NEUTRAL_ELEMENT;
        }
        if (lx >= l && rx <= r) {
            return tree[x].sum;
        }
        int m = (lx + rx) / 2;
        ll s1 = get(l, r, x * 2 + 1, lx, m);
        ll s2 = get(l, r, x * 2 + 2, m, rx);
        return op_sum(s1, s2);
    }
    ll get(int l, int r) {
        return get(l, r, 0, 0, size);
    }
};

int main()
{
    int a, b, c;
    cin >> a >> b >> c;
    multiset<int> aa;
        aa.insert(a);
        aa.insert(b);
        aa.insert(c);
    int min_size = *aa.begin();
    aa.erase(aa.begin());
    string s, t, u;
    
    s.assign(min_size, 'a');
    t.assign(min_size, 'b');
    u.assign(min_size, 'c');
    for (size_t i = 0; i < *aa.begin() - min_size; i++)
    {
        u.push_back('c');
    }
    min_size = *aa.begin();
    aa.erase(aa.begin());
    if (*aa.begin() - min_size > s.size()) {
        cout << "No\n";
        return 0;
    }
    for (size_t i = 0; i < *aa.begin() - min_size; i++)
    {
        u.push_back('b');
    }
    cout << "Yes\n";
    s = "x" + s;
    t = "x" + t;
    u = "x" + u;
    if (a <= b && a <= c) {
        if (c >= b) {
            cout << t << '\n' << s << '\n' << u << '\n';
        }
        else {
            cout << s << '\n' << t << '\n' << u << '\n';
        }
    }
    else if (b <= c && b <= a) {
        if (a >= c) {
            cout << s << '\n' << u << '\n' << t << '\n';

        }
        else {
            cout << t << '\n' << u << '\n' << s << '\n';
        }
    }
    else {
        if (a >= b) {
            cout << u << '\n' << s << '\n' << t << '\n';
        }
        else {
            cout << u << '\n' << t << '\n' << s << '\n';
        }
    }

}
