﻿#include <iostream>
#include <map>
#include <set>
#include <vector>
#include <algorithm>
#include <fstream>
#include <string>
#include <queue>
#include <deque>
#include <unordered_set>
#include <unordered_map>
#include <cmath>
#include <iomanip>
#include <bitset>
#include <random>


#pragma GCC optimize("O3")
#pragma GCC target("avx2")

using namespace std;
typedef long long ll;
typedef long double ld;
typedef unsigned long long ull;

mt19937 rnd(1046527);

vector<ll> parent, ranks, cou;
unordered_set<ll> w, b;

ll sqn;
ll s_x, s_y;

void make_set(ll v) {
    parent[v] = v;
    ranks[v] = 0;
    cou[v] = 1;
}

int find_set(int v) {
    if (v == parent[v]) return v;
    return parent[v] = find_set(parent[v]);
}

void union_sets(int a, int b) {
    a = find_set(a);
    b = find_set(b);
    if (a != b) {
        if (ranks[a] < ranks[b]) swap(a, b);
        parent[b] = a;
        cou[a] = cou[a] + cou[b];
        cou[b] = 0;
        if (ranks[a] == ranks[b]) ++ranks[a];
    }
}

void near(ll cur, ll x, ll y, char col) {
    ll num;
    for (ll i = -1; i < 2; ++i) {
        for (ll j = -1; j < 2; ++j) {
            if (i == 0 && j == 0) continue;
            if (x + i - s_x < 0 || y + j - s_y < 0 || y + j - s_y >= sqn) continue;

            num = (x + i - s_x) * sqn + (y + j - s_y);
            if (num > cur) continue;

            if (col == 'W' && w.find(num) != w.end())
                union_sets(cur, num);
            else if (col == 'B' && b.find(num) != b.end())
                union_sets(cur, num);
        }
    }
}

void solve(int n, int sqn) {
    w.clear();
    b.clear();
    parent.resize(3 * n, 0);
    ranks.resize(3 * n, 0);
    cou.resize(3 * n, 0);

    s_x = rnd() % 2000;
    s_x -= 1000;
    s_y = rnd() % 2000;
    s_y -= 1000;
    
    ll x, y;
    char ch;
    int st;
    int i = -1;
    while (true) {
        i++;
        x = i / sqn + s_x;
        y = i % sqn + s_y;
        cout << "? " << x << ' ' << y << endl;
        cin >> ch;
        if (ch == 'W')
            w.insert(i);
        else
            b.insert(i);
        make_set(i);
        near(i, x, y, ch);
        if (cou[find_set(i)] >= n) {
            st = i;
            break;
        }
    }

    cout << "! " << ch << ' ';
    int sti = find_set(st), coucou = 0;
    for (int i = 0; i <= st; ++i) {
        if (find_set(i) == sti) {
            coucou++;
            x = i / sqn + s_x;
            y = i % sqn + s_y;
            cout << x << ' ' << y << ' ';
        }
    }
    cout << endl;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    // string file = "func";
    // ifstream cin(file + ".in");
    // ofstream cout(file + ".out");

    int t, n;
    cin >> t >> n;
    sqn = sqrt(2 * n);
    parent.resize(3 * n);
    ranks.resize(3 * n);
    cou.resize(3 * n);
    //t = 1;
    while (t--)
        solve(n, sqn);
}
