from bisect import bisect_left
from sys import exit


n = int(input())


def insert_segment(segments, segment):
    i = bisect_left(segments, segment)

    if i < len(segments):
        other = segments[i]

        if segment[1] + 1 >= other[0]:
            new_segment = (segment[0], max(segment[1], other[1]))
            segments[i] = new_segment
        else:
            segments.insert(i, segment)
    else:
        segments.insert(i, segment)

    if i - 1 >= 0:
        left = segments[i - 1]
        right = segments[i]

        if left[1] + 1 >= right[0]:
            new_segment = (left[0], max(left[1], right[1]))
            segments[i - 1] = new_segment
            segments.pop(i)


def get_segments(initial_value, async_plus):
    async_plus.sort()

    m = 0
    max_i = 0
    for i, e in enumerate(async_plus):
        if e[0] - 1 > m:
            break

        max_i += 1
        m += e[0]

    segments = []
    insert_segment(segments, (initial_value, initial_value + m))

    for i in range(max_i, len(async_plus)):
        e = async_plus[i][0]
        new_segments = []
        for segment in segments:
            new_segments.append((segment[0] + e, segment[1] + e))

        for segment in new_segments:
            insert_segment(segments, segment)

    return segments


async_eq = {}
async_plus = []

last_sync_eq = (0, -1)
right_async_eq = False
sync_plus = []

for i in range(n):
    op, v, t = input().split()

    if t == 'async':
        if op == '=':
            right_async_eq = True
            vv = int(v)
            if vv not in async_eq:
                async_eq[vv] = i
        else:
            async_plus.append((int(v), i))
    else:
        if op == '=':
            right_async_eq = False
            last_sync_eq = (int(v), i)
            sync_plus = []
        else:
            if not async_plus and not async_eq:
                last_sync_eq = (last_sync_eq[0] + int(v), last_sync_eq[1])
            else:
                sync_plus.append((int(v), i))


initial_values = []
if not right_async_eq:
    value = last_sync_eq[0] + sum(e for e, i in sync_plus)
    initial_values.append((last_sync_eq[1], value))


sync_plus = sync_plus[::-1]
for e, i in async_eq.items():
    initial_values.append((n, e))
    curr_init = e

    for ee, j in sync_plus:
        if j < i:
            continue

        curr_init += ee
        initial_values.append((j, curr_init))


initial_values.sort(reverse=True)

async_plus.sort(key=lambda x: x[1])

segments = []
summ = 0
for i, v in initial_values:
    while async_plus and async_plus[-1][1] > i:
        vv, ii = async_plus.pop()
        summ += vv

    new_segments = get_segments(v + summ, async_plus[::])
    for segment in new_segments:
        insert_segment(segments, segment)

result = 0
for segment in segments:
    result += segment[1] - segment[0] + 1

print(result)



