from collections import defaultdict


t, n = map(int, input().split())
import random

field = dict()
test_sum = 0

# def test_point(x, y):
#     global test_sum
#     test_sum += 1
#     if (x, y) not in field:
#         field[(x, y)] = 'W' if random.randint(0, 1) == 1 else 'B'
#     return field[(x, y)]


def test_point(x, y):
    print(f'? {x} {y}', flush=True)
    color = input()
    if color == '0':
        return None
    assert 'B' == color or 'W' == color
    # return color == 'W'
    return color


def neighbours(x, y):
    return [(x + dx, y + dy) for dx in [-1, 0, 1] for dy in [-1, 0, 1]]

class ColorCount:
    def __init__(self, *, b=0, w=0):
        self.b = 0
        self.w = 0

def score(cc):
    if cc.b > 0 and cc.w > 0:
        return cc.b + cc.w
    return 1


def visit_all_but(p, visited: set, points: dict, color: str):
    if p in visited:
        return
    visited.add(p)
    for np in neighbours(p[0], p[1]):
        if (np in visited) or (np not in points) or (points[np].color != color):
            continue
        visit_all_but(np, visited, points, color)
    pass


def best_component(color: str, points: dict):
    global_visited = set()
    max_len = 0
    best_comp = set()
    for p, comp in points.items():
        c = comp.color
        if c != color or p in global_visited:
            continue
        visited = set()
        visit_all_but(p, visited, points, color)
        global_visited.update(visited)
        if len(visited) > max_len:
            max_len = len(visited)
            best_comp = visited
    return best_comp


class Component:
    def __init__(self, parent: None, count: int, color: str):
        self.parent = parent
        self.count = count
        self.color = color

    def get_count(self):
        if self.parent is None:
            return self.count
        return self.parent.get_count()

    def add_count(self, c):
        self.count += c

    def add_parent(self, parent):
        if self.parent is None:
            self.parent = parent
            self.parent.add_count(self.count)
            return
        self.parent.add_parent(parent)

    def get_parent(self):
        if self.parent is None:
            return self
        self.parent = self.parent.get_parent()
        return self.parent


def solve():
    # todo: select random
    boundary = dict()
    known = dict()
    next_point = (0, 0)
    best_comp = set()
    best_color = None
    # for i in range(n * 2):
    while True:
        color = test_point(next_point[0], next_point[1])
        if color is None:
            return None, None
            # raise ValueError('should not be here!')
        np_component = Component(None, 1, color)
        known[next_point] = np_component
        if next_point in boundary:
            boundary.pop(next_point)
        for p in neighbours(next_point[0], next_point[1]):
            if p in known:
                if known[p].color == np_component.color and (known[p].get_parent() is not np_component):
                    known[p].add_parent(np_component)
                continue
            if p in boundary:
                ccount = boundary[p]
            else:
                ccount = ColorCount()
            if color == 'B':
                ccount.b += 1
            elif color == 'W':
                ccount.w += 1
            else:
                raise ValueError('invalid color name')
            boundary[p] = ccount
        if np_component.count >= n:
            return np_component.color, best_component(np_component.color, known)
        next_point = None
        best_score = -999
        for p, cc in boundary.items():
            if score(cc) > best_score:
                next_point = p
                best_score = score(cc)
        # b_comp = best_component('B', known)
        # w_comp = best_component('W', known)
        # best_comp_len = max(len(b_comp), len(w_comp))
        # if best_comp_len > len(best_comp):
        #     if len(b_comp) > len(w_comp):
        #         best_comp = b_comp
        #         best_color = 'B'
        #     else:
        #         best_comp = w_comp
        #         best_color = 'W'
        # if best_comp_len >= n:
        #     break
    # return best_color, best_comp


def make_ans(color: str, component: set):
    component = list(component)[:n]
    points = " ".join([f'{p[0]} {p[1]}' for p in component])
    return f'! {color} {points}'


for _ in range(t):
    field = dict()
    start_ = test_sum
    color, comp = solve()
    if color is None:
        # to get wrong answer
        break
    # print(len(comp), f'consumed {test_sum - start_}')

    # if len(comp) < n:
    #     print(f'broke with {len(comp)}')
    #     raise ValueError("heheh")
    # print(f'# len = {len(comp)}')
    print(make_ans(color, comp), flush=True)
    # print(field)
# print(f'total consumed {test_sum} out of {t * n * 2}')