#pragma GCC optimize("Ofast")
#include <vector>
#pragma GCC target("avx2,avx,sse,fma")

#include <bits/stdc++.h>
using namespace std;

#define ff first
#define ss second
#define all(x) x.begin(),x.end()
#define rall(x) x.rbegin(),x.rend()

using ull = unsigned long long;
using ll = long long;
using ld = long double;

const int B = 512;
const int INF = 1e9;

struct LIS {
    int n;
    vector<int> val;
    int ans;
    LIS(int n) : n(n) {
        val.resize(n + 1, INF);
        val[0] = -INF;
        ans = 0;
    }
    void add(int x) {
        int len = upper_bound(all(val), x) - val.begin();
        if(val[len - 1] < x && x < val[len]) {
            ans = max(ans, len);
            val[len] = x;
        }
    }
};

void solve() {
    int n, q;
    cin >> n >> q;
    vector<int> a(n);
    for(int i = 0; i < n; i++) {
        cin >> a[i];
    }
    vector<vector<tuple<int, int, int>>> queries(n / B + 1);
    for(int i = 0; i < q; i++) {
        int l, r;
        cin >> l >> r;
        l--, r--;
        queries[l / B].push_back({r, i, l});
    }
    vector<int> ans(q);
    for(int i = 0; i < (int)queries.size(); i++) {
        sort(all(queries[i]));
        const int rb = min(n - 1, i * B + B - 1);
        const int lb = i * B;
        const int sz = rb - lb + 1;
        LIS lis1(sz);
        vector<int> pref(sz, 0);
        for(int i = rb; i >= lb; i--) {
            lis1.add(a[i]);
            //cout << rb - i << '\n';
            pref[rb - i] = lis1.ans;
        }
        int cur_rb = rb;
        LIS lis2(n);
        for(auto [r, ind, l] : queries[i]) {
            if(r - l + 1 <= B) {
                LIS cur(r - l + 1);
                for(int j = l; j <= r; j++) cur.add(a[j]);
                ans[ind] = cur.ans;
            } else {
                while(cur_rb < r) {
                    cur_rb++;
                    lis2.add(a[cur_rb]);
                }
                ans[ind] = (max(pref[rb - l], lis2.ans) + pref[rb - l] + lis2.ans + 1) / 2;
            }
        }
    }
    for(int i = 0; i < q; i++) cout << ans[i] << '\n';
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int testsCount = 1;
    cin >> testsCount;

    for (int curTest = 1; curTest <= testsCount; curTest++) {
        solve();
    }

    return 0;
}
