import sys
def solve():
    try:
        n_line = sys.stdin.readline()
        if not n_line:
            return
        n = int(n_line.strip())
    except EOFError:
        return
    except ValueError:
        return
    instructions = []
    total_plus_sum = 0
    has_equal = False
    for _ in range(n):
        line = sys.stdin.readline().split()
        if not line:
            break
        inst_type = line[0]
        value = int(line[1])
        is_async = (line[2] == "async")
        
        instructions.append({
            'type': inst_type,
            'value': value,
            'is_async': is_async
        })
        
        if inst_type == '+':
            total_plus_sum += value
        elif inst_type == '=':
            has_equal = True

    distinct_final_values = set()
    if not has_equal:
        distinct_final_values.add(total_plus_sum)
        print(len(distinct_final_values))
        return

    MAX_SUM = 1000001

    dp = [False] * MAX_SUM
    dp[0] = True
    current_max_subset_sum = 0
    S_sync_plus_post = 0
    for i in range(n - 1, -1, -1):
        current_inst = instructions[i]

        if current_inst['type'] == '+':
            v = current_inst['value']
            
            if current_inst['is_async']:

                for s in range(current_max_subset_sum, -1, -1):
                    if dp[s]:
                        new_sum = s + v
                        if new_sum < MAX_SUM:
                            dp[new_sum] = True
                current_max_subset_sum = min(MAX_SUM - 1, current_max_subset_sum + v)
            else:
                S_sync_plus_post += v
        elif current_inst['type'] == '=':
            v_set = current_inst['value']
            can_be_last_set = True
            for j in range(i + 1, n):
                if instructions[j]['type'] == '=' and not instructions[j]['is_async']:
                    can_be_last_set = False
                    break
            if can_be_last_set:
                base_value = v_set + S_sync_plus_post
                for s in range(current_max_subset_sum + 1):
                    if dp[s]:
                        distinct_final_values.add(base_value + s)
    print(len(distinct_final_values))
if __name__ == "__main__":
    solve()
