#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

bool isGreaterOrEqual(const string& num1, const string& num2) {
    if (num1.length() != num2.length()) {
        return num1.length() > num2.length();
    }
    return num1 >= num2;
}


string subtract(string num1, const string& num2) {
    string result = "";
    int n1 = num1.length();
    int n2 = num2.length();
    int borrow = 0;
    
    reverse(num1.begin(), num1.end());
    string num2_rev = num2;
    reverse(num2_rev.begin(), num2_rev.end());

    for (int i = 0; i < n1; i++) {
        int d1 = num1[i] - '0';
        int d2 = i < n2 ? num2_rev[i] - '0' : 0;
        
        int diff = d1 - d2 - borrow;
        
        if (diff < 0) {
            diff += 10;
            borrow = 1;
        } else {
            borrow = 0;
        }
        result += to_string(diff);
    }

    while (result.length() > 1 && result.back() == '0') {
        result.pop_back();
    }
    
    reverse(result.begin(), result.end());
    return result;
}


string divide(string dividend, const string& divisor) {
    string quotient = ""; 

    if (divisor == "0") return ""; 
    if (isGreaterOrEqual(divisor, dividend) && divisor != dividend) return "0";
    
    string current_dividend = "";
    
    for (char digit : dividend) {
        current_dividend += digit;

        while (current_dividend.length() > 1 && current_dividend[0] == '0') {
            current_dividend.erase(0, 1);
        }
        
        int count = 0;
        while (isGreaterOrEqual(current_dividend, divisor)) {
            current_dividend = subtract(current_dividend, divisor);
            count++;
        }
        
        quotient += to_string(count);
    }
    
    size_t first_digit = quotient.find_first_not_of('0');
    if (string::npos == first_digit) {
        return "0";
    }
    return quotient.substr(first_digit);
}

void solve() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    string s, c_str;
    if (!(cin >> s >> c_str)) {
        return;
    }

    int n = s.length();
    int c_len = c_str.length();

    for (int i = 1; i < n; ++i) {
        int a_len = i;
        int b_len = n - i;

        if ((a_len > 1 && s[0] == '0') || (b_len > 1 && s[i] == '0')) {
            continue;
        }
        
        
        if (a_len - b_len > c_len || a_len < b_len + c_len - 1) {
            continue;
        }
        
        string a_str = s.substr(0, i);
        string b_str = s.substr(i); 

        string division_result = divide(a_str, b_str);

        if (division_result == c_str) {
          
            
            cout << a_str << " " << b_str << "\n";
            return;
        }
    }
}

int main() {
    solve();
    return 0;
}