import sys

def solve():

    try:
        n_line = sys.stdin.readline()
        if not n_line:
            return
        n = int(n_line.strip())
    except Exception:
        return

    dim_1 = []
    dim_2 = []
    dim_3 = []
    for _ in range(n):
        line = sys.stdin.readline().split()
        if not line:
            break
        

        try:
            w, h, d = map(int, line)
        except ValueError:
            continue
            

        dimensions = sorted([w, h, d])
 
        dim_1.append(dimensions[0])
        dim_2.append(dimensions[1])
        dim_3.append(dimensions[2])
        

    s1 = min(dim_1)

    s2 = min(dim_2)

    s3 = min(dim_3)

    V_max = s1 * s2 * s3
    
    print(V_max)

if __name__ == "__main__":
    solve()