n = int(input())
instructions = []

for i in range(n):
    parts = input().split()
    op = parts[0]
    val = int(parts[1])
    is_async = (parts[2] == "async")
    instructions.append((op, val, is_async))

possible_values = set()

def backtrack(used, order):
    if len(order) == n:
        A = 0
        for idx in order:
            op, val, _ = instructions[idx]
            if op == '=':
                A = val
            else:
                A += val
        possible_values.add(A)
        return
    
    for i in range(n):
        if i in used:
            continue
        
        op_i, val_i, async_i = instructions[i]
        
        can_place = True
        for j in range(i):
            _, _, async_j = instructions[j]
            if not async_j and j not in used:
                can_place = False
                break
        
        if can_place:
            backtrack(used | {i}, order + [i])

backtrack(set(), [])
print(len(possible_values))
