﻿#include <iostream>
#include <cmath>
#include <map>
#include <set>
#include <queue>
#include <stack>
#include <iomanip>
#include <deque>
#include <string>
#include <vector>
#include <compare>
#include <algorithm>
#include <cstdint>
#include <numeric>
#include <limits>

using namespace std;
using intl = long long;
using uintl = unsigned long long;

using ll = long long;
using pll = pair<ll, ll>;
using pii = pair<int, int>;
using vlong = vector<ll>;
using vvlong = vector<vlong>;
using vint = vector<int>;
using vvint = vector<vint>;

#define all(x) x.begin(), x.end()
#define rall(x) x.rbegin(), x.rend()
#define ff first
#define ss second
#define pb push_back

constexpr ll INFL = 1e18;
constexpr int INF = 2e9;
using numtype = double;

struct vec2 {
    numtype x, y;
    vec2(numtype _x = 0, numtype _y = 0) : x(_x), y(_y) {}
    vec2 operator+(const vec2& other) const noexcept {
        return vec2{ x + other.x, y + other.y };
    }
    vec2 operator-(const vec2& other) const noexcept {
        return vec2{ x - other.x, y - other.y };
    }
    vec2 operator*(numtype scl) {
        return vec2{ x * scl, y * scl };
    }
};

numtype sq_length(const vec2& uv) {
    return uv.x * uv.x + uv.y * uv.y;
}

numtype dot(const vec2& a, const vec2& b) {
    return a.x * b.x + a.y * b.y;
}

numtype cross(const vec2& a, const vec2& b) {
    return a.x * b.y - a.y * b.x;
}

bool ask(pll xy) {
    char ans;
    cout << "? " << xy.ff << " " << xy.ss << endl;
    cout.flush();
    cin >> ans;
    return ans == 'B';
}

vector<pll> moves = {
    {0, 1},
    {0, -1},
    {1, 0},
    {-1, 0},
    {-1, -1},
    {1, -1},
    {-1, 1},
    {1, 1}
};



pll next(const set<pll>& border, const map<pll, bool>& color) {
    for (auto& el : border) {
        ll white = 0, black = 0;
        for (auto& move : moves) {
            pll to = { el.ff + move.ff, el.ss + move.ss };
            if (color.find(to) != color.end()) {
                if (color.at(to)) black++;
                else white++;
            }
        }
        if (white && black) return el;
    }
    return *border.begin();
}

void insert(set<pll>& border, map<pll, bool>& color, pll point) {
    color[point] = ask(point);
    border.erase(point);
    for (auto move : moves) {
        pll to = { point.ff + move.ff, point.ss + move.ss };
        if (color.find(to) == color.end()) border.insert(to);
    }
}

void solve(ll n) {
    map<pll, bool> color;
    set<pll> border;
    insert(border, color, {0, 0});
    for (int i = 0; i < 599; i++) {
        pll nxt = next(border, color);
        insert(border, color, nxt);
    }

    queue<pll> q;
    set<pll> used;
    map<pll, ll> comp;
    ll c = 0;
    for (auto& p : color) {
        pll point = p.ff;
        bool clr = p.ss;
        ll cnt = 0;
        if (used.find(point) == used.end()) {
            c++;
            q.push(point);
            used.insert(point);
            while (!q.empty()) {
                pll cur = q.front();
                q.pop();
                for (pll move : moves) {
                    pll to = { move.ff + cur.ff, move.ss + cur.ss };
                    if (color.find(to) != color.end() && color[to] == color[cur] && used.find(to) == used.end()) {
                        used.insert(to);
                        q.push(to);
                        comp[to] = c;
                        cnt++;
                        if (cnt == n) {
                            set<pll> ans;
                            for (auto& p : comp) {
                                pll point = p.ff;
                                ll cmp = p.ss;
                                if (cmp == c) ans.insert(point);
                            }
                            cout << "! " << (color[*ans.begin()] ? 'B' : 'W') << " ";
                            for (auto& el : ans) cout << el.ff << " " << el.ss << " ";
                            cout << endl;
                            cout.flush();
                        }
                    }
                }
            }
        }
    }


}

int main() {
    std::ios_base::sync_with_stdio(false);
    cout.tie(nullptr);
    cin.tie(nullptr);
    int tt = 1;
    cin >> tt;
    ll n; cin >> n;
    while (tt--) {
        solve(n);
    }
}