def solve(a, b, c):
    if a == b == c == 0:
        return ("Yes", "a", "a", "a")

    a, b, c = sorted(((a, 0), (b, 1), (c, 2)), key=lambda x: x[0])
    if a[0] + b[0] < c[0]:
        return ("No",)
    else:
        fst = "a" * c[0]
        scd = "b" * c[0]
        thrd = "a" * b[0] + "b" * a[0]
        res = [0, 0, 0]
        res[2 - a[1]] = scd
        res[2 - b[1]] = fst
        res[2 - c[1]] = thrd
        return ["Yes"] + res

def dist(s1, s2):
    n, m = len(s1), len(s2)
    dp = [[0 for i in range(m + 1)] for j in range(n + 1)]
    dp[0][0] = 0

    for i in range(1, n + 1):
        dp[i][0] = i
    for j in range(1, m + 1):
        dp[0][j] = j

    for i in range(1, n + 1):
        for j in range(1, m + 1):
            dp[i][j] = min(dp[i-1][j] + 1, dp[i][j-1] + 1, dp[i-1][j-1] + int(s1[i-1] != s2[j-1]))

    return dp[-1][-1]

def check(a, b, c, s, t, u):
    return dist(s, t) == a and dist(s, u) == b and dist(t, u) == c

def stress():
    from random import randint

    while True:
        a = randint(0, 100)
        b = randint(0, 100)
        c = randint(0, 100)

        res = solve(a, b, c)
        
        if a + b + c - max(a, b, c) < max(a, b, c):
            if res[0] != "No":
                print("Expected No:", a, b, c)
                break
        else:
            if res[0] != "Yes":
                print("Expected Yes", a, b, c)
                break

            if not check(a, b, c, res[1], res[2], res[3]):
                print("Wrong answer, (a, b, c) =", a, b, c)
                break

# stress()
a, b, c = map(int, input().split())
print(*solve(a, b, c), sep="\n")
