import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;

public class Main {

    static Box ourBox;
    static String nameFixed;

    static String[] vars;
    public static void main(String[] args) {
        Scanner scan = new Scanner(System.in);

        vars = new String[3];
        vars[0] = "x";
        vars[1] = "y";
        vars[2] = "z";

        int amountBox = scan.nextInt();

        ArrayList<Box> inputBox = new ArrayList<>();
        ArrayList<OutputBox> outputBox = new ArrayList<>();

        int minX = 1001;
        int minY = 1001;
        int minZ = 1001;

        for (int i = 0; i < amountBox; i++) {
            int x = scan.nextInt();;
            int y = scan.nextInt();
            int z = scan.nextInt();

            minX = minX < x ? minX : x;
            minY = minX < y ? minY : y;
            minZ = minZ < z ? minZ : z;

            inputBox.add(new Box(x, y, z));
        }

        ourBox = new Box(minX, minY, minZ);

        if (minX < minY && minX < minZ) {
            nameFixed = "x";
        }
        if (minY < minX && minY < minZ) {
            nameFixed = "y";
        }
        if (minZ < minY && minZ < minX) {
            nameFixed = "z";
        }

        for (Box some : inputBox) {
            outputBox.add(new OutputBox(some, ourBox));
        }

        for (String simv : vars) {
            if (simv.equals(nameFixed)) {
                continue;
            }

            int minDobav = 1002;
            boolean isAllTrue = true;

            for (OutputBox some : outputBox) {
                int get = some.getMinPositive(simv);

                if (get == 1002) {
                    isAllTrue = false;
                    break;
                }

                minDobav = Math.min(minDobav, get);
            }

            if (isAllTrue) {
                ourBox.add(simv, minDobav);
            }
        }

        System.out.println(ourBox.get("x") * ourBox.get("y") * ourBox.get("z"));
    }
}
class Box {
    HashMap<String, Integer> map;

    Box(int x, int y, int z) {
        map = new HashMap<>();
        map.put("x", x);
        map.put("y", y);
        map.put("z", z);
    }

    void set(String name, int val) {
        map.put(name, val);
    }

    int get(String name) {
        return map.get(name);
    }

    void add(String name, int val) {
        int curVal = map.get(name);
        curVal += val;
        map.put(name, curVal);
    }
}

class Pair {
    Box outBox;
    Box inBox;
    HashMap<String, String> sootv;

    Pair(Box outBox, Box inBox, HashMap<String, String> sootv) {
        this.inBox = inBox;
        this.outBox = outBox;
        this.sootv = sootv;
    }

    boolean checkValid() {
        return (outBox.get("x") >= inBox.get(sootv.get("x")) &&
                outBox.get("y") >= inBox.get(sootv.get("y")) &&
                outBox.get("z") >= inBox.get(sootv.get("z")));
    }

    int getSub(String key) {
        return outBox.get(key) - inBox.get(sootv.get(key));
    }
}

class OutputBox {
    ArrayList<Pair> list;
    OutputBox(Box outBox, Box inBox) {
        list = new ArrayList<>();

        HashMap<String, String> sootv = new HashMap<>();
        sootv.put("x", "x");
        sootv.put("y", "y");
        sootv.put("z", "z");
        list.add(new Pair(outBox, inBox, sootv));

        sootv = new HashMap<>();
        sootv.put("x", "x");
        sootv.put("y", "z");
        sootv.put("z", "y");
        list.add(new Pair(outBox, inBox, sootv));

        sootv = new HashMap<>();
        sootv.put("x", "y");
        sootv.put("y", "x");
        sootv.put("z", "z");
        list.add(new Pair(outBox, inBox, sootv));

        sootv = new HashMap<>();
        sootv.put("x", "y");
        sootv.put("y", "z");
        sootv.put("z", "x");
        list.add(new Pair(outBox, inBox, sootv));

        sootv = new HashMap<>();
        sootv.put("x", "z");
        sootv.put("y", "x");
        sootv.put("z", "y");
        list.add(new Pair(outBox, inBox, sootv));

        sootv = new HashMap<>();
        sootv.put("x", "z");
        sootv.put("y", "y");
        sootv.put("z", "x");
        list.add(new Pair(outBox, inBox, sootv));

        int amountEl = 6;


        for (int i = 0; i < amountEl; i++) {
            if (!list.get(i).checkValid()) {
                list.remove(list.get(i));
                amountEl--;
                i--;
            }
        }
    }

    int getMinPositive(String key) {
        int minRazn = 1002;
        for (Pair some : list) {
            if (some.getSub(key) > 0 && some.getSub(key) < minRazn) {
                minRazn = some.getSub(key);
            }
        }

        return minRazn;
    }
}