#include<iostream>
#include<vector>
#include<map>
#include<set>
#include<iomanip>
#include<deque>
#include <queue>

using namespace std;

map<pair<int, int>, bool> cache;
bool isWhite(int x, int y) {
    if(cache.contains({x, y})) {
        return cache[{x, y}];
    }
    cout << '?' << ' ' << x << ' ' << y << '\n';
    cout.flush();
    char c;
    cin >> c;
    cache[{x,y}] = c=='W';
    return c == 'W';
}

vector<pair<int, int>> curFig;
set<pair<int, int>> visited;
bool find8(int x, int y, int limit) {
    bool curColor = isWhite(x, y);
    visited.clear();
    cache.clear();
    curFig = {{x, y}};
    queue<pair<int, int>> q;
    vector<pair<int, int>> moves = {{-1, -1}, {-1, 0}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, 0}, {1, 1}};
    for(auto [dx, dy] : moves) {
        q.push({x+dx, y+dy});
    }
    while(!q.empty() && curFig.size() < limit) {
        auto [vx, vy] = q.front();
        q.pop();
        if(visited.contains({vx, vy}))
            continue;
        if(isWhite(vx, vy) == curColor) {
            curFig.push_back({vx, vy});
            for(auto [dx, dy] : moves) {
                q.push({vx + dx, vy + dy});
            }
        }
        visited.insert({vx, vy});
    }
    return curColor;
}

void solve(int n) {
    for(int x = 0; x < 30000; x += 600) {
        bool color = find8(x, 0, n);
        char c = (color ? 'W' : 'B');
        if(curFig.size() == n) {
            cout << "! " << c << ' ';
            for(int i = 0; i < curFig.size(); i++) {
                cout << curFig[i].first << ' ' << curFig[i].second << ' ';
            }
            cout << '\n';
            return;
        }
    }
}

int main() {
//    ios_base::sync_with_stdio(false);
//    cin.tie(0);

    int t;
    cin >> t;
    int n;
    cin >> n;
    while(t--) {
        solve(n);
    }
}