#include <bits/stdc++.h>

using namespace std;

#define int long long int
void solve() {
    int n, s, h; cin >> n >> s >> h;

    enum Type {
        Gate,
        Key,
        In,
        Out
    };

    struct Event {
        int x;
        int index;
        Type type;
        int pair;
    };

    vector<int> reached(2 * n + 2, -1);
    vector<int> dist(2 * n + 2, -1);
    vector<Event> events;
    std::map<int, int> gate_to_key_index;
    events.emplace_back(s, 0, Type::In, 0);
    events.emplace_back(h, 1, Type::Out, 0);
    for (int i = 0; i < n; ++i) {
        int k, g; cin >> k >> g;
        gate_to_key_index[g] = events.size();
        dist[events.size()] = abs(k - g);
        events.emplace_back(k, events.size(), Type::Key, 0);
        events.emplace_back(g, events.size(), Type::Gate, 0);
    }

    sort(events.begin(), events.end(), [](auto a, auto b){
        return a.x < b.x;
    });

    int start_idx = 0;
    for (int i = 0; i < events.size(); ++i) {
        if (events[i].type == Type::In) {
            start_idx = i;
            break;
        }
    }

    auto extend_left = [&](int& idx) {
        if (idx < 0) {
            return -1;
        }
        auto e = events[idx];
        if (e.type == Type::Key || e.type == Type::Out) {
            auto prev = events[idx + 1];
            reached[e.index] = reached[prev.index] + abs(e.x - prev.x);
            return 0;
        }
        if (e.type == Type::Gate) {
            auto paired = gate_to_key_index[e.x];
            if (reached[paired] == -1) {
                return -1;
            }
            reached[e.index] = reached[paired] + dist[paired];
            return 0;
        }
        return -1;
    };

    auto extend_right = [&](int& idx) {
        if (idx == events.size()) {
            return -1;
        }
        auto e = events[idx];
        if (e.type == Type::Key || e.type == Type::Out) {
            auto prev = events[idx - 1];
            reached[e.index] = reached[prev.index] + abs(e.x - prev.x);
            return 0;
        }
        if (e.type == Type::Gate) {
            auto paired = gate_to_key_index[e.x];
            if (reached[paired] == -1) {
                return -1;
            }
            reached[e.index] = reached[paired] + dist[paired];
            return 0;
        }
        return -1;
    };

    reached[events[start_idx].index] = 0;
    int left_idx = start_idx - 1;
    int right_idx = start_idx + 1;
    while (true) {
        auto rl = extend_left(left_idx);
        auto rr = extend_right(right_idx);
//        for (int i = 0; i < reached.size(); ++i) {
//            cout << reached[i] << ' ';
//        }
//        cout << endl;
        if (reached[1] != -1) {
            break;
        }
        if (rl == -1 && rr == -1) {
            break;
        }
    }

    cout << reached[1] << endl;
}

signed main() {
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }

}