#include <bits/stdc++.h>

using namespace std;

#define int long long

using pii = pair<int, int>;
using vpi = vector<pii>;

map<pii, pii> king;
map<pii, bool> used;
map<pii, vpi> component;
map<pii, bool> color;

void unite(pii k1, pii k2) {
  //  cout << "unite " << k1.first << " " << k1.second << " -- " << k2.first << " " << k2.second << endl;
    /*if (component[k1].size() < component[k2].size()) {
        swap(k1 , k2);
    }*/
    for (auto& el : component[k2]) {
        component[k1].emplace_back(el);
        king[el] = k1;
    }
    component.erase(k2);
}

pii select(pii k) {
    vector<pii> to_select;
    assert(component[k].size() > 0);

    int LIMIT_TO_SELECT = 15;

    for (auto& [x, y] : component[k]) {
        for (auto dx : {-1, 0, 1}) {
            for (auto dy : {-1,0, 1}) {
                if (dx == 0 && dy == 0) continue;
                if (used[make_pair(x+dx,y+dy)]) continue;
                to_select.emplace_back(x+dx, y+dy);
            }
        }
        if (to_select.size() > LIMIT_TO_SELECT) {
            break;
        }
    }

    int random_idx = rand() % to_select.size(); // TODO: maybe rng?

    return to_select[random_idx];
}

bool ask(pii to_ask) {
    cout << "? " << to_ask.first << " " << to_ask.second << std::endl;
    string s;
    cin >> s;
    used[to_ask] = true;
    if (s == "0") {
        assert(false);
    }

    if (s == "B") {
        color[to_ask] = true;
        return true;
    } else {
        color[to_ask] = false;
        return false;
    }
}

void solve(int n) {
    ask(make_pair(0, 0));
    component[{0, 0}].emplace_back(0, 0);
    king[{0, 0}] = {0, 0};

    while (true) {
        pii mx_king = {0, 0};
        int mx_sz = component[mx_king].size();
        for (const auto& [k, c] : component) {
            if (c.size() > mx_sz) {
                mx_king = k;
                mx_sz = c.size();
            }
        }
      //  cout << mx_king.first << " " << mx_king.second;
       // cout << "debug mx_sz " << mx_sz << endl;

        if (mx_sz >= n) {
            if (color[mx_king]) {
                cout << "! B ";
            } else {
                cout << "! W ";
            }
            int sz = 0;
            for (const auto& [x, y] : component[mx_king]) {
                if (sz == n) break;
                cout << x << " " << y << " ";
                sz++;
            }
            cout << endl;
            return;
        }

        pii to_select = select(mx_king);

        king[to_select] = to_select;
        component[to_select].push_back(to_select);
        ask(to_select);
        for (auto dx : {-1,0, 1}) {
            for (auto dy : {-1,0, 1}) {
                if (dx == 0 && dy == 0) continue;

                pii kek = make_pair(to_select.first+dx, to_select.second+dy);
                if (used[kek] && color[kek] == color[to_select]) {
                    unite(to_select, king[kek]);
                }
            }
        }
     //   cout << "comp size " << component.size() << endl;
    }
}

void clearall() {
    king.clear();
    component.clear();
    used.clear();
    color.clear();
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);
    int nt = 1;
    cin >> nt;
    int n;
    cin >> n;
    while (nt--) {
        solve(n);
        clearall();
    }
}
