#include <bits/stdc++.h>
#include <ext/pb_ds/tree_policy.hpp>
#include <ext/pb_ds/assoc_container.hpp>
using namespace std;
using namespace __gnu_pbds;
typedef long long ll;
typedef unsigned long long ull;
typedef long double ld;
typedef pair<int, int> pii;
typedef pair<ll, ll> pll;
typedef pair<double, double> pdd;
typedef vector<ll> vll;
typedef vector<int> vii;

template<typename A, typename B> ostream& operator<< (ostream& out, pair<A, B> p){
    out<< p.first <<" "<<p.second;
    return out;

}
template<typename A> ostream& operator<< (ostream& out, vector<A> p){
    for(int i = 0; i < p.size(); i ++){
        out<<p[i]<<" ";
    }
    return out;
}

template<typename A> istream& operator>>(istream& in, vector<A>& p){
    for(int i = 0; i < p.size(); i ++){
        in >> p[i];
    }
    return in;
}
template<typename A, typename B>  istream& operator>>(istream& in, pair<A, B>& p){
    in >> p.first >> p.second;
    return in;
}

#define FOR(i, begin, end) for (int i = (begin) - ((begin) > (end)); i < (end) - ((begin) > (end)); i += 1)
const ld PI = asin(1) * 2;

vii sieve (int n) {
    vector<bool> mask(n, true);
    mask[0] = false;
    mask[1] = false;
    for (int i = 0; i * i < n; i++) {
        if (!mask[i]) continue;
        for (int j = i * i; j < n; j += i) {
            mask[j] = false;
        }
    }

    vii res;
    for (int i = 0; i < n; i++) if (mask[i]) res.push_back(i);
    return res;
}

namespace FFT {
        int n;
        vector <int> r;
        vector <complex<ld>> omega;
        int logN, pwrN;

        void initLogN(){
            logN = 0;
            pwrN = 1;
            while (pwrN < n) {
                pwrN *= 2;
                 logN++;
            }
            n = pwrN;
        }

        void initOmega(){
            for (int i = 0;i < pwrN; i++) {
                cout << i << " " << omega.size() << '\n';
                omega[i] = {cos(2.0*i*PI / n), sin (2.0*i*PI/n)};

            }
        }

        void initR() {
            r[0] = 0;
            FOR (i, 1, pwrN) {
                r[i] = r[i/2] / 2 + ((i & 1) << (logN-1));
            }
        }

        void initArrays(){
            r.clear();
            r.resize(pwrN);
            omega.clear();
            omega.resize(pwrN);
        }

        void init (int n) {
            FFT::n = n;
            initLogN();
            initArrays();
            initOmega();
            initR();
        }

        void fft (complex<ld> a[], complex<ld> f[]) {
            FOR(i, 0, pwrN) {
                f[i] = a[r[i]];
            }
            for (ll k = 1; k < pwrN; k *= 2) {
                for (ll i = 0; i < pwrN; i += 2*k) {
                    for (ll j = 0; j < k; j++) {
                        auto z = omega[j * n / (2 * k)] * f[i + j + k];
                        f[i + j + k] = f[i + j] - z;
                        f[i + j] += z;
                    }
                }
            }

        }
    }

void solve () {
//    int n = 5;
//    cin >> n;

////    FFT::n = n * 2;
//    FFT::init(n * 2);
////    return;
//
//
//    vector <complex<ld>> a (FFT::n, 0), f(FFT::n, 0);
//    for (int i = 0; i < 5; i++) a[i] = 1;
//
//    FFT::fft(a.data(), f.data());
//    for (int i = 0; i < f.size(); i++) f[i] *= f[i];
//    for (int i = 0; i < f.size(); i++) f[i] = conj(f[i]);
//    FFT::fft(f.data(), a.data());
//
//    for (int i = 0; i < f.size(); i++) cout << (a[i].real() * (1.0/16.0)) <<" ";

int n;
cin >> n;

int start = 0;
vector <int> seqplus;
vector <int> asyncplus;
vector <int> asynceq;
for (int i = 0; i < n;i++) {
    string op, sync;
    int val;
    cin >> op >> val >> sync;

    if (sync[0] == 'a') {
        if (op == "+") asyncplus.push_back(val);
        else asynceq.push_back(val);
    }

    else {
        if (op == "+") seqplus.push_back(val);
        else {
            start = val;
            seqplus.clear();
        }
    }
}
int constexpr binsize = 45;

int maxsize = 2 *(500 * binsize + 1);
FFT::init(maxsize);

vector <complex <ld>> inp (FFT::n, 0), outp(FFT::n);
vector <vector <complex<ld>>> bins((asynceq.size() - 1) / binsize + 1, vector<complex<ld>>(FFT::n, 1));

for (int i = 0; i < asynceq.size(); i++) {
    inp[0] = 1;
    inp [asynceq[i]] = 1;
    FFT::fft(inp.data(), outp.data());
    inp [asynceq[i]] = 0;

    for (int j = 0; j < FFT::n; j++) {
        bins [i/binsize][j] *= outp[j];
    }
}

for (auto& v: bins) {
    ///vector <>
}

    vector <vector <complex<ld>>> binvals((asynceq.size() - 1) / binsize + 1, vector<complex<ld>>(FFT::n, 1));




}

void solveL() {
    ld* est = new ld [2001 * 2001]; // k, n
    for (int i = 1; i < 2001; i++) {
        est [i * 2001 + i] = ld(i) / 2;
        est [1 * 2001 + i] = 0.5;
    }
    for (int i = 2; i < 2001; i++) {
        for (int j = i + 1; j < 2001;j++) {
            ld x = est[i * 2001 + j - 1] - est[(i-1)* 2001 + j-1];
            est [i * 2001 +j] = (1 - x) * ((x + 1) /2 + est[(i-1) * 2001 + j-1]) + x * est[i * 2001 +j-1];
        }
    }

    int t;
    cin >> t;
    for (int test = 0; test < t; test++) {
        int n, k, d;
        cin >> n>>k>>d;

        cout << fixed << setprecision(10) << (est[k * 2001 +n] + ld(1)* n*d /2) << '\n';
    }
}


int main() {
    //return 0;
//    std::cout << "Hello, World!" << std::endl;
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    solveL();

//solve();
    return 0;
}
