
#include <bits/stdc++.h>

using namespace std;

mt19937_64 rng{2393663439};

using ll = long long;
using ull = unsigned long long;

ll my_rand(ll mx) {
    return rng() % mx;
}

ll my_rand(ll mn, ll mx) {
    ll len = mx - mn;
    return my_rand(len) + mn;
}

static constexpr int N = 1337;
static constexpr bool STRESS = false;
int global_total = 0;
array<int, 2> que[N];
int sqr_used[200][200];

const int dx[8]{-1, -1, -1, 0, 0, 1, 1, 1};
const int dy[8]{-1, 0, 1, -1, 1, -1, 0, 1};

struct dsu {
    int n;
    vector<int> par;
    vector<vector<int>> cur_comp;
    explicit dsu(int n) : n(n), par(n), cur_comp(n) {
        iota(par.begin(), par.end(), 0);
        for (int i = 0; i < n; ++i) {
            cur_comp[i] = {i};
        }
    }

    int get(int v) {
        return par[v] = par[v] == v ? v : get(par[v]);
    }

    bool unite(int v, int u) {
        v = get(v);
        u = get(u);
        if (v == u) {
            return false;
        }

        if (cur_comp[u].size() > cur_comp[v].size()) {
            swap(u, v);
        }

        par[u] = v;
        for (auto&& x : cur_comp[u]) {
            cur_comp[v].push_back(x);
        }
        cur_comp[u].clear();
        return true;
    }
};

void solve() {
    int n;
    if constexpr (STRESS) {
        n = 300;
        cout << "NEW TEST" << endl;
    } else {
        cin >> n;
    }
    int start_x = my_rand(-1e8, 1e8), start_y = my_rand(-1e8, 1e8);
    int total = 0;

    auto query = [&](int x, int y) {
        ++global_total;
        ++total;
        if constexpr (STRESS) {
//            cerr << "QUERY x = " << x << " y = " << y << endl;
            return my_rand(2);
        } else {
            cout << "? " << x + start_x << ' ' << y + start_y << endl;
            char c; cin >> c;
            return c == 'W';
        }
    };

    const int MAX_TOTAL = 2 * 300;
    constexpr int SHIFT = 50;

    auto shift_data = [&](int cur_x, int cur_y) {
        return array<int, 2>{cur_x + SHIFT, cur_y + SHIFT};
    };

    int cur_sqr_size = 0;

    dsu helper(100 * 100);
    vector<vector<int>> cols(100, vector<int>(100, -1));
    map<array<int, 2>, int> num_from_point;
    vector<array<int, 2>> points;
    auto get_num = [&](int x, int y) {
        auto it = num_from_point.find(array<int, 2>{x, y});
        if (it == num_from_point.end()) {
            num_from_point[array<int, 2>{x, y}] = points.size();
            points.push_back(array<int, 2>{x, y});
        }
        return num_from_point[array<int, 2>{x, y}];
    };

    // here we pass x and y already shifted !!!
    auto add_vertex = [&](int x, int y) -> bool {
        if (cols[x][y] != -1) return false;
        int col = query(x, y);
        cols[x][y] = col;
        for (int k = 0; k < 8; ++k) {
            int new_x = x + dx[k];
            int new_y = y + dy[k];
            if (new_x >= 0 && new_y >= 0) {
                if (cols[new_x][new_y] == -1) continue;
                if (cols[new_x][new_y] == cols[x][y]) {
                    auto num1 = get_num(x, y);
                    auto num2 = get_num(new_x, new_y);
//                    cerr << " num 1 = " << num1 << endl;
//                    cerr << " num 2 = " << num2 << endl;
                    helper.unite(num1, num2);
//                    cerr << "united\n";
                    auto results = helper.cur_comp[helper.get(num1)];
//                    cerr << " CUR COMP SZ = " << results.size() << endl;
//                    for (auto x : results) {
//                        cerr << x << ' ';
//                    }
//                    cerr << "\n comp finished\n";
                    if (results.size() >= n) {
                        if constexpr (!STRESS) {
                            cout << "! " << (col ? 'W' : 'B');
                            results.resize(n);
                            for (auto idx : results) {
                                cout << ' ' << points[idx][0] + start_x << ' ' << points[idx][1] + start_y;
                            }
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    };

    cur_sqr_size = 0;

    auto solve_comp = [&](int comp_idx) {
        while(helper.cur_comp[helper.get(comp_idx)].size() < n) {
            auto cur_version = helper.cur_comp[helper.get(comp_idx)];
            for (auto idx : cur_version) {
                auto [x, y] = points[idx];
                for (int k = 0; k < 8; ++k) {
                    int new_x = x + dx[k];
                    int new_y = y + dy[k];
                    if (new_x >= 0 && new_y >= 0) {
                        if (add_vertex(new_x, new_y)) {
                            return;
                        }
                    }
                }
            }
        }
    };

    auto check_best_comp = [&]() {
        set<int> seen_comps;
        for (auto [x, y] : points) {
            auto num = num_from_point[array<int, 2>{x, y}];
            auto comp = helper.get(num);
            if (seen_comps.contains(comp)) {
                continue;
            }
            seen_comps.insert(comp);
            if (helper.cur_comp[comp].size() >= 49) {
                solve_comp(comp);
                return true;
            }
        }
        return false;
    };

//    add_vertex(shift_data(0, 0)[0], shift_data(0, 0)[1]);
    while(true) {
        ++cur_sqr_size;
        for (int j = 0; j < cur_sqr_size * 2 + 1; ++j) {
            auto [x, y] = shift_data(-cur_sqr_size, -cur_sqr_size + j);
            if (add_vertex(x, y)) return;
        }
        for (int j = 1; j < cur_sqr_size * 2 + 1; ++j) {
            auto [x, y] = shift_data(-cur_sqr_size + j, -cur_sqr_size);
            if (add_vertex(x, y)) return;
        }
        for (int j = 1; j < cur_sqr_size * 2 + 1; ++j) {
            auto [x, y] = shift_data(cur_sqr_size, -cur_sqr_size + j);
            if (add_vertex(x, y)) return;
        }
        for (int j = 1; j < cur_sqr_size * 2; ++j) {
            auto [x, y] = shift_data(cur_sqr_size - j, cur_sqr_size);
            if (add_vertex(x, y)) return;
        }
        if (check_best_comp()) {
            return;
        }
    }

    assert(false);
}
// TIP To <b>Run</b> code, press <shortcut actionId="Run"/> or click the <icon src="AllIcons.Actions.Execute"/> icon in the gutter.
int main() {
    int tt;
    int was_tt = 0;
    if constexpr (STRESS) {
        tt = 1000;
        was_tt = tt;
    } else {
        cin >> tt;
    }
    int passed = 0;
    while(tt--) {
        solve();
        ++passed;
        if constexpr (STRESS) {
            cout << "PASSED " << passed << endl;
        }
    }
//    cout << "AVERAGE SPENT = " << double(global_total) / was_tt;
    return 0;
}