#include <iomanip>
#include <iostream>
#include <vector>
#include <algorithm>
#include <map>
#include <set>

using namespace std;
using ll = long long;

const int max_n = 2'000;
const int max_k = 2'000;
vector<vector<double>> z;

void init() {
    z.resize(max_n + 1);
    z[0].assign(max_k + 1, 0.0);
    for (int n = 1; n <= max_n; ++n) {
        z[n].resize(max_k + 1);
        z[n][0] = 0.0;
        for (int k = 1; k <= max_k; ++k) {
            double a = min(1.0, z[n - 1][k] - z[n - 1][k - 1]);
            z[n][k] = a * z[n - 1][k] + (1.0 - a) * z[n - 1][k - 1] + 0.5 * (1.0 - a * a);
        }
    }
}

void solve() {
    double k, n, d;
    cin >> n >> k >> d;
    cout << fixed << std::setprecision(12);
    cout << n * d * 0.5 + 0.5 + z[n - 1][k - 1];
}

int main() {
    std::ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

#ifdef BOBR
    freopen("../input.txt", "r", stdin);
    freopen("../output.txt", "w", stdout);
#endif

    init();

    int t = 1;
    cin >> t;
    while (t--) {
        solve();
        cout << '\n';
    }
}